﻿# -*- encoding: utf-8 -*-
=begin
=転職_職業データ設定セクション by Foo

転職画面で扱う職業データを設定するセクションです

==更新履歴
Date     Version Author Comment
13/08/05 1.1.0   Foo    表示行数設定の変更
13/08/05 1.0.0   Foo    試作

=end

#==============================================================================
# ■ NWConst::JobChange
#==============================================================================
module NWConst::JobChange
  JOB_DESC_TEXT = {
    1 => # 戦士 / Warrior
      [[
        "An ordinary fighter and the first step for all warrior-type jobs. Better than average attack and defense, but poor with and against magic. Capable of using basic weapons like swords and spears, but not knight swords or heavy weapons. Learns mostly basic sword skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Rapier,Spear,Axe,Club,Scythe,Flail,Armor",
        "   Helmet,Shield",
        "Skills: Dagger,Sword,Rapier",
        "Passive: None",
        "",
      ]],
    2 => # 剣士 / Swordsman
      [[
        "An accomplished master of the blade. Newfound strength grants usage of the mighty knight sword, a wide range of sword skills, and enhanced attack and defense. Unfortunately, magic is still out of the question.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Rapier,Spear,Axe,Scythe,Armor",
        "   Heavy Armor,Helmet,Heavy Helmet,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Rapier",
        "Passive: None",
        "",
      ]],
    3 => # 剣聖 / Swordmaster
      [[
        "The highest class of a swordsman who is proficient at using Katanas as well as swords. This class is the object of admiration for all aspiring sword users. This class allows for the acquisition of unrivaled sword skills that target multiple targets. Katana skills can also be used; it is truly the pinnacle of Sword mastery.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Rapier,Katana,Spear,Axe,Scythe",
        "   Armor,Heavy Armor,Helmet,Heavy Helmet,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Katana",
        "Passive: Sword Mastery,Katana Mastery",
        "",
      ]],
    4 => # 魔剣士 / Monster Swordsman
      [[
        "A skillful swordsman who is proficient with Dark swordplay, wielding powerful skills that deal great damage at the cost of the user's vitality. Has the ability to wield Magic Swords and specializes in Rapier and Spellblade skills. Those who master the power of darkness can truly be called legendary warriors.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Great Sword,Rapier,Spear,Axe",
        "   Scythe,Armor,Heavy Armor,Helmet,Heavy Helmet,Shield",
        "   Heavy Shield",
        "Skills: Dagger,Sword,Rapier,Spellblade",
        "Passive: Dark Strike,Sword Mastery",
        "",
      ]],
    5 => # 聖堂騎士 / Temple Knight
      [[
        "A holy soldier bearing a Priest's piety and a Warrior's bravery. Wields SP-fueled healing magic and adept with heavy spears. Learns abilities that aid in banishing the undead to the grave.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Spear,Heavy Spear,Armor,Heavy Armor,Helmet",
        "   Heavy Helmet,Shield,Heavy Shield",
        "Skills: Rapier,Spear,White Magic,Holy",
        "Passive: None",
        "",
      ]],
    6 => # ホーリーナイト / Holy Knight
      [[
        "The highest ranking position for holy warriors who have mastered many sacred mysteries. The Spear of the Church that destroys evil and heals the wounded. A Holy Knight's training teaches many powerful holy and spear skills. With their powerful recovery skill, a holy knight can heal all their allies at once.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Spear,Heavy Spear,Armor,Heavy Armor",
        "   Helmet,Heavy Helmet,Shield,Heavy Shield",
        "Skills: Rapier,Spear,White Magic,Holy",
        "Passive: Rapier Mastery,Spear Mastery",
        "",
      ]],
    7 => # 魔法戦士 / Spellsword
      [[
        "Specialized fighter trained in swordplay and magic, the Spellsword style is born. A Warrior's strength is retained and black magic can be used. The sword itself can be enchanted with various attributes to inflict elemental damage and status ailments.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Rapier,Armor,Helmet,Shield",
        "Skills: Dagger,Sword,Black Magic,Spellblade",
        "Passive: None",
        "",
      ]],
    8 => # マスターソーサラー / Master Swordcerer
      [[
        "The ultimate Spellsword who takes swordsmanship and magical might to the highest level, possessing the power to destroy any enemy before them. The Master Swordcerer possesses a wide variety of skills including Black Magic, a talent for wielding Magic Swords, and the ability to strike entire groups of foes at once.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Rapier,Magic Sword,Armor,Helmet,Shield",
        "Skills: Dagger,Sword,Black Magic,Spellblade",
        "Passive: Sword Mastery",
        "",
      ]],
    9 => # 竜騎士 / Dragoon
      [[
        "Spear-wielding aerodynamic knight who leaps to the skies and toys with foes. Spear skills consist of harpy slaying attacks and blinding speed. Magic stats on the other hand aren't very respectable.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Rapier,Spear,Heavy Spear,Armor,Heavy Armor,Helmet",
        "   Heavy Helmet,Shield,Heavy Shield",
        "Skills: Rapier,Spear",
        "Passive: Eva +10%",
        "",
      ]],
    10 => # ホーリーランサー / Holy Lancer
      [[
        "Lancers who shine with Heaven's light as they hunt the wicked, slaying enemies with exceptional power and speed. The Holy Lancer wields an extremely powerful skill that consumes both MP and SP. Among all, the holy lancer is the bane of demon-class monsters.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Rapier,Spear,Heavy Spear,Armor,Heavy Armor,Helmet",
        "   Heavy Helmet,Shield,Heavy Shield",
        "Skills: Rapier,Spear",
        "Passive: Eva +10%,Rapier Mastery,Spear Mastery",
        "",
      ]],
    11 => # 邪竜騎士 / Dark Dragoon
      [[
        "A Dragoon who mastered the Spear Arts and uses the power of Darkness. Pouring all of their power into their attacks, the Dark Dragoon wields powerful spear and dark skills. The Darkness inherent in their spears makes them a fatal threat for opponents with no Darkness resistance. The more life force they offer, the more destructive power Dark Dragoons wield.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Rapier,Spear,Heavy Spear,Armor,Heavy Armor,Helmet",
        "   Heavy Helmet,Shield,Heavy Shield",
        "Skills: Rapier,Spear",
        "Passive: Eva +10%,Rapier Mastery,Spear Mastery",
        "",
      ]],
    12 => # 侍 / Samurai
      [[
        "An honorable swordsman who hails from the East and wields a unique sword: the Katana. A Samurai boasts unparalleled power, wielding an impressive display of Katana skills. Despite their low defense, the Samurai excel in attack power. Armed with powerful Katana skills, a Samurai is even capable of striking all enemies at once.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Katana",
        "Skills: Katana",
        "Passive: Crit +20%,Eva +15%",
        "",
      ]],
    13 => # 聖侍 /Samurai Saint
      [[
        "A Samurai who walks a pure path, slaying darkness with holy powers. Wielding a Katana blessed with Holy energy, the Samurai Saint mercilessly destroys evil spirits For the price of MP and SP, the Samurai Saint can unleash a powerful Holy Katana skill. Besides powerful sword and katana skills, it is possible to master the ability \"Serene Mind\".",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Katana",
        "Skills: Katana",
        "Passive: Crit +30%,Eva +15%,Katana Mastery",
        "",
      ]],
    14 => # 魔侍 / Dark Samurai
      [[
        "A Samurai who defied the law of the gods and walks the path of darkness. The Dark Samurai wields Katana skills that can stop an enemy's breath, killing them instantly. However, the use of this skill comes at a cost of the user's life force. Through this job, one can learn the most powerful sword skills, making them a master of the battlefield.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Katana",
        "Skills: Katana",
        "Passive: Crit +30%,Eva +15%,Katana Mastery",
        "",
      ]],
    15 => # パワーファイター / Power Fighter
      [[
        "A crude fighter who thoroughly smashes foes with hidden power. Forgoes the blade in favor of blunt weapons like clubs and flails. Like most warriors, attack is great while magic stays low.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Great Sword,Axe,Club,Flail,Armor,Heavy Armor,Helmet",
        "   Heavy Helmet,Shield,Heavy Shield",
        "Skills: Axe,Club,Flail",
        "Passive: Crit +10%,Endure",
        "",
      ]],
    16 => # ギガファイター / Giga Fighter
      [[
        "The ultimate power fighter that destroys everyone and everything with overwhelming power. Able to put tremendous power into their weapon, crushing even the most heavily armored enemies. Despite their lack of magic, Gigafighters have superior attack and defensive power. Master the mysteries of the Axe, Club, and Flail, and you will be a force to be reckoned with.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Great Sword,Axe,Club,Flail,Armor,Heavy Armor,Helmet",
        "   Heavy Helmet,Shield,Heavy Shield",
        "Skills: Axe,Club,Flail",
        "Passive: Crit +20%,Super Endure,Power Mastery",
      ]],
    17 => # 狂戦士 / Savage Warrior
      [[
        "Rabid feral warrior fighting on pure instinct, tearing foes with extreme strength at the expense of sanity. In exchange, the SP regeneration rate is doubled and new Axe skills can be learned.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Great Sword,Axe,Club,Flail,Armor,Helmet,Shield",
        "Skills: Axe,Club,Flail",
        "Passive: Crit +15%,Double SP Charge,SP Regen +30%,Berserk",
        "",
      ]],
    18 => # ベルセルク / Berserker
      [[
        "Warriors who have abandoned all logic and reason to obtain ultimate physical power. Despite the unparalleled ability to annihilate any foe, Berserkers are unable to be commanded. With an accelerated SP recovery, a variety of powerful skills can be executed in rapid succession. Along with the ability 'Triple SP Charge', a Berserker learns many powerful Axe Skills.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Great Sword,Axe,Club,Flail,Armor,Helmet,Shield",
        "Skills: Axe,Club,Flail",
        "Passive: Crit +30%,Triple SP Charge,SP Regen +30%",
        "   Power Mastery,Rampage",
      ]],
    19 => # 陰陽剣士 / Tao Swordsman
      [[
        "Unique fencer with Tao-infused blades homes in on enemy weaknesses. A tactical job mixing offense and defense, it has access to both Sword and Taoism skills and learns element boosting abilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Scythe,Rod,Fan,Armor,Helmet,Shield",
        "Skills: Dagger,Sword,Taoism",
        "Passive: Mag Eva +10%,Mag Counter +25%",
        "",
      ]],
    20 => # 九字剣神 / Kuji-In Sword God
      [[
        "A magic swordsman that expertly combines the powers of Taoism and swordplay. These warriors can completely annihilate their enemies by summoning spirits with their blade. The Kuji-In Sword God can imbue their sword with the natural elements, making all of their attacks extremely powerful. With the ability to enhance their attributes, Kuji-In Sword Gods possess tremendous power.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Magic Sword,Katana,Scythe,Rod,Fan",
        "   Armor,Helmet,Shield",
        "Skills: Dagger,Sword,Taoism",
        "Passive: Mag Eva +10%,Mag Counter +50%,Sword Mastery",
        "",
      ]],

    22 => # 武道家 / Martial Artist
      [[
        "A fighter who makes use of their own body through punches and kicks. Especially adept at critical hits, counters, and using high agility to dodge attacks. Learns various unarmed skills, instant KO skills, and body-strengthening skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fist,Club,Gi",
        "Skills: Unarmed",
        "Passive: Crit +15%,Counter +25%,Eva +20%",
        "",
      ]],
    23 => # 拳豪 / Overpowering Fist
      [[
        "Remarkable martial artist rewarded with a buffed counter rate, evasion, and critical hits after intense training. Techniques worthy of a Black Belt and even healing arts through sheer force of will become available.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fist,Club,Gi",
        "Skills: Unarmed",
        "Passive: Crit/Eva +20%,Counter +50%",
        "",
      ]],
    24 => # 拳聖 / Saint Fist
      [[
        "A Martial Artist who is pure of heart and possesses a clear mind. Warriors of this rank possess extraordinary fighting focus, allowing them to counter almost every attack. The Saint Fist demonstrates overwhelming power against evil monsters with their Holy and Fist skills. Martial Artists of this rank are extremely powerful and can even use their chakra to heal their allies.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fist,Club,Gi",
        "Skills: Unarmed",
        "Passive: Crit +30%,Counter +75%,Eva +20%,Fist Mastery",
        "",
      ]],
    25 => # 邪拳王 / Dark Fist
      [[
        "A dark fighter that has mastered forbidden fist techniques and whose heart is stained in darkness. With their exceptional sense for close combat, they are capable of frequently countering and inflicting critical hits. Learns several dark unarmed skills, mercilessly killing foes with their fists. The price of sacrificing one's life force is necessary to master these forbidden arts.",
        "",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fist,Club,Gi",
        "Skills: Unarmed",
        "Passive: Crit +30%,Counter +75%,Eva +20%,Fist Mastery",
      ]],
    26 => # 魔導拳士 / Magus Fist
      [[
        "Hybrid monk who fights with magic-infused fists. In addition to black magic, this oddly mixed class wields elemental punches that spell doom for foes weak in both body and mind. A special skill restores MP.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fist,Club,Gi",
        "Skills: Unarmed,Black Magic",
        "Passive: Crit/Eva +15%,Mag Counter +25%",
        "",
      ]],
    27 => # フォースモンク / Force Monk
      [[
        "The ultimate warrior who can channel overwhelming magic into their fists. By imbuing the power of every element into their fists, a Force Monk can defeat any enemy. Black Magic can also be used, making the Force Monk a physical and magical threat. Without a doubt, the Force Monk is a master of elements and an all-around powerful class.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fist,Club,Gi",
        "Skills: Unarmed,Black Magic",
        "Passive: Crit +20%,Eva +15%,Mag Counter +50%,Fist Mastery",
        "",
      ]],
    28 => # パラディン / Paladin
      [[
        "Faithful monk specializing in self-defense. While decent in attack, most skills prioritize the party's safety and overall health via holy power, ranging from recovery to revival.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Fist,Club,Staff,Gi",
        "Skills: Unarmed,White Magic,Holy",
        "Passive: Crit +15%",
        "",
      ]],
    29 => # ゴッドハンド / God Hand
      [[
        "The ultimate warrior whose devotion to their faith knows no bounds. Warriors of this rank are bestowed with great power to protect their allies and mercilessly defeat evil. A God Hand's faith grants them great strength and teaches them the ultimate healing skill that sacrifices themselves for their allies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Fist,Club,Staff,Gi",
        "Skills: Unarmed,White Magic,Holy",
        "Passive: Crit +20%,Fist Mastery",
        "",
      ]],
    30 => # バトルマスター / Battle Master
      [[
        "Undisputed master of sword and fist, this class mixes relentless punches and countless slashes into a unique style backed by a handsome attack stat. However, the same cannot be said for magic.",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Rapier,Spear,Heavy Spear,Fist",
        "   Axe,Club,Scythe,Flail,Armor,Heavy Armor,Helmet,Heavy Helmet",
        "   Shield,Heavy Shield",
        "Skills: Dagger,Sword,Multiweapon,Unarmed",
        "Passive: Crit +15%,Counter +25%,Eva +15%,HP Regen +5%,",
        "   Great Defense, Dual Wield",
      ]],
    31 => # バトルエンペラー /  Battle Emperor
      [[
        "A unique warrior who has mastered the peak of swordsmanship and martial arts. Wields multiple weapons and combines them with martial arts in combat. Has mastered overwhelming consecutive attacks and boasts great destructive power. Can also learn Triple Attack, making normal attacks very powerful.",
        "",
        "",
        "",
		"",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Great Sword,Rapier,Spear",
        "   Heavy Spear,Fist,Axe,Club,Scythe,Flail",
        "Skills: Dagger,Sword,Multiweapon,Unarmed",
        "Passive: Evasion +15%,Critical +25%,Counter +50%,HP Regen +10%,",
        "   Ultimate Defense,Dual Wield",
      ]],
    33 => # 魔法使い / Magician
      [[
        "The first step for all magic-user jobs. Specializes in magic; extremely poor at physical combat. Low defense and health; weak to being hit. Learns basic Black Magic focusing on the three primary magic elements.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Scythe,Rod,Grimoire,Robe,Magic Hat",
        "Skills: Black Magic",
        "Passive: None",
        "",
      ]],
    34 => # 黒魔導師 / Black Mage
      [[
        "Magician walking down the path of Black Magic, taking great pride in learning stronger elemental magic bolstered by an equally strong magic stat. It goes without saying that they're not fit for physical combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Scythe,Rod,Grimoire,Robe,Magic Hat",
        "Skills: Black Magic",
        "Passive: None",
      ]],
    35 => # 灼熱魔導師 / Inferno Mage
      [[
        "The ultimate Black Mage who specializes in Fire magic. The Inferno Mage wields a torrent of hellfire that burns the enemy away. Along with a resistance to Fire, Inferno mages are immune to the Burn status effect. With the ability to strengthen their elemental magic, the Inferno Mage is the master of Fire.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Scythe,Magic Sword,Rod,Grimoire,Robe",
        "   Magic Hat",
        "Skills: Black Magic,Dark",
        "Passive: Magic Mastery",
        "",
      ]],
    36 => # 輝氷魔導師 / Arctic Mage
      [[
        "The ultimate Black Mage who specializes in Ice magic. The Arctic Mage wields a torrent of ice, freezing enemies in their tracks. Along with a resistance to Ice, Arctic mages are immune to the Freeze status effect. With the ability to strengthen their elemental magic, the Arctic Mage is the master of Ice.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Scythe,Magic Sword,Rod,Grimoire,Robe",
        "   Magic Hat",
        "Skills: Black Magic,Dark",
        "Passive: Magic Mastery",
        "",
      ]],
    37 => # 極雷魔導師 / Gigavolt Mage
      [[
        "The ultimate Black Mage who specializes in Lightning magic. The Gigavolt Mage wields a torrent of lightning, rendering enemies to smoldering ash. Along with a resistance to Lightning, Gigavolt mages are immune to the Shock status effect. With the ability to strengthen their elemental magic, the Gigavolt Mage is the master of Lightning.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Magic Sword,Scythe,Rod,Grimoire,Robe",
        "   Magic Hat",
        "Skills: Black Magic,Dark",
        "Passive: Magic Mastery",
        "",
      ]],
    38 => # 時魔導師 / Time Mage
      [[
        "Branch of the mage family that taps into time and space. Unfit for combat and more suited for support, ranging from hastening allies to stopping enemies in their tracks. Furthermore, warp magic can be learned for fast travel to previous locations.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Scythe,Rod,Grimoire,Robe,Magic Hat",
        "Skills: Time Magic",
        "Passive: None",
        "",
      ]],
    39 => # 時空魔導師 / Spacetime Mage
      [[
        "A powerful rank of magician who can control space and time. The Spacetime Mage can manipulate the flow of time to the advantage of their allies. A Spacetime Mage can also control space by summoning meteorites from the sky itself, combining useful support magic with powerful attack magic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Magic Sword,Scythe,Rod,Grimoire,Robe",
        "   Magic Hat",
        "Skills: Time Magic",
        "Passive: Magic Mastery",
        "",
      ]],
    40 => # 召喚士 / Summoner
      [[
        "Magician capable of calling forth magical beasts that attack or heal. Much stronger than bog-standard spells and has the MP cost to match, making it fitting for decisive blows but infeasible for constant casting.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Scythe,Rod,Grimoire,Robe,Magic Hat",
        "Skills: Summoning",
        "Passive: None",
        "",
      ]],
    41 => # 精霊召喚士 / Spirit Summoner
      [[
        "The ultimate summoner who can call upon the spirits and the divine. Despite the large MP cost, a Spirit Summoner possesses exceptionally powerful attack magic. With an increased amount of MP and the ability to cast the ultimate summoning spells, a Spirit Summoner is a powerful force on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Scythe,Magic Sword,Rod,Grimoire,Robe",
        "   Magic Hat",
        "Skills: Summoning",
        "Passive: Magic Mastery",
        "",
      ]],
    42 => # 陰陽師 / Taoist
      [[
        "Unique magician hailing from Yamatai. Seemingly weak magic attacks inflict potentially crippling weaknesses on all enemies with a chance of status ailments.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Rod,Fan,Robe,Magic Hat",
        "Skills: Taoism",
        "Passive: Eva/Mag Eva +5%",
        "",
      ]],
    43 => # 天地陰陽師 / Cosmic Taoist
      [[
        "A talented Taoist who has polished their spiritual skills to annihilate groups of foes by inflicting abnormal statuses and reduced magical resistances. Can do extreme damage by targeting the weakened resists.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Magic Sword,Scythe,Rod,Fan,Robe,Magic Hat",
        "Skills: Taoism",
        "Passive: Eva/Mag Eva +5%,Magic Mastery, Fan Mastery",
        "",
      ]],
    44 => # 僧侶 / Priest
      [[
        "A pious monk who serves Ilias and specializes in healing magic. Invaluable on long trips for their ability to heal outside of combat. Not good at physical combat, although better than magic users. Learns support magic to assist the party.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Club,Staff,Whip,Grimoire,Robe,Magic Hat",
        "Skills: White Magic",
        "Passive: None",
        "",
      ]],
    45 => # 白魔導師 / White Mage
      [[
        "Hardworking Priest promoted to a true mage after mastering the basics. Learns stronger recovery and support magic along with a few offensive Holy spells. An unwritten requirement for truly dedicated parties.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Club,Staff,Whip,Grimoire,Robe,Magic Hat",
        "Skills: White Magic",
        "Passive: None",
        "",
      ]],
    46 => # 聖魔導師 / Holy Mage
      [[
        "A mage who concentrates their faith and power solely into White Magic, using Holy attacks that embodies Divine Strength to purge evil. Holy Mages can heal their allies and supplement their strength with great power. With this ultimate healer among your party, success is guaranteed.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Club,Staff,Whip,Grimoire,Robe,Magic Hat",
        "Skills: White Magic,Holy",
        "Passive: Magic Mastery",
        "",
      ]],
    47 => # 賢者 / Sage
      [[
        "Magical expert who has trained in the ways of both the priest and the magician. Able to wield both Black and White Magic, allowing them to attack and heal all on their own. The Sage also learns powerful magical support abilities such as MP cost reduction and boosters for elemental skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Magic Sword,Club,Scythe,Whip,Staff,Rod",
        "   Fan,Grimoire,Robe,Magic Hat",
        "Skills: White Magic,Black Magic",
        "Passive: MP Cost 75%",
      ]],
    48 => # 森羅万象士 / Cosmic Magus
      [[
        "Highest-class mage with knowledge of all living things. Uses skills of all types, including Holy and Dark. Reduced MP consumption allows many uses of powerful spells, including ones that expend all MP.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Magic Sword,Club,Scythe,Whip,Staff,Rod",
        "   Fan,Grimoire,Robe,Magic Hat",
        "Skills: White Magic,Black Magic,Time Magic,Summoning,Holy,Dark",
        "   Taoism",
        "Passive: MP Cost 50%,Magic Mastery",
      ]],
    49 => # 魔法少女 / Magical Girl
      [[
        "A bringer of justice with a pure heart who transforms into a Magical Girl. Although unreliable under normal circumstances, Magical Girls can wield powerful offensive and supportive magic after transforming. The transformation time is limited, but ideal for short-term battles.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Magic Sword,Scythe,Staff,Rod,Bow,Grimoire",
        "   Gun,Robe,Magic Hat",
        "Skills: White Magic,Black Magic",
        "Passive: MP Regen +1%",
        "",
      ]],
    50 => # 魔女 / Witch
      [[
        "Magician who has given in to destruction and curses and whose once pure heart has become tainted. Can use exceptionally potent offensive magic once transformed. Can spread curses and calamities to groups of enemies with very strong status ailments and instant death effects. An extremely powerful entity capable of annihilating enemies in one go.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Magic Sword,Scythe,Staff,Rod,Bow,Grimoire,Gun",
        "Skills: White Magic,Black Magic,Time Magic,Heroism",
        "Passive: MP Regen +2%,Magic Mastery",
        "",
      ]],
    52 => # 狩人 / Hunter
      [[
        "Experts with the bow, Hunters have extremely high accuracy and also learn elemental skills. Hunters live up to their name by learning skills especially effective against certain races. Their damage dealing is excellent, but their defense is less than a Warrior's.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Bow,Whip,Boomerang",
        "Skills: Scythe,Bow,Whip,Throwing",
        "Passive: Crit/Eva +10%,Forest Strength,Slayer Boost 100%",
        "",
      ]],
    53 => # ボウマスター / Bowmaster
      [[
        "Keen-eyed Hunter after rigorous training. Learns skills that inflict severe damage to even more races, such as Insects and Alraunes. Shooting down whole groups of foes at once becomes child's play for this class. Defenses are still fragile, so do be careful.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Bow,Whip,Boomerang",
        "Skills: Scythe,Bow,Whip,Throwing",
        "Passive: Crit +15%,Eva +10%,Forest Strength,Slayer Boost 100%",
        "",
      ]],
    54 => # 神弓手 / Holy Archer
      [[
        "A holy Hunter boasting superior Bow and Holy skills. The Holy Archer wields arrows that deal holy damage at the cost of SP and MP, as well as hunt down monsters such as Lamias and Scyllas. Despite the large SP cost, the force behind each arrow is well worth it.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Bow,Whip,Boomerang",
        "Skills: Scythe,Bow,Whip,Throwing",
        "Passive: Crit +20%,Eva +10%,Super Forest Strength",
        "   Slayer Boost 100%,Bow Mastery",
        "",
      ]],
    55 => # 影狩人 / Shadow Hunter
      [[
        "A Hunter who has devoted themselves to the power of darkness. Capable of taking down prey such as elves and fairies, that ordinary hunters lack the skill to hunt. The Shadow Hunter uses forbidden skills that bury enemies in darkness, annihilating them at the cost of the user's life force.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Bow,Whip,Boomerang",
        "Skills: Scythe,Bow,Whip,Throwing",
        "Passive: Crit +20%,Eva +10%,Super Forest Strength",
        "   Slayer Boost 100%,Bow Mastery",
        "",
      ]],
    56 => # ガンナー / Gunner
      [[
        "Dynamic sharpshooter that swaps the old for the new. No enemy can avoid the bullets, their speed dwarfing and downing Harpies and Succubi. Average attack stat aside, even healing ammo can be acquired.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gun",
        "Skills: Gun",
        "Passive: Crit +15%,Slayer Boost 100%",
        "",
      ]],
    57 => # 神銃士 / God's Eye
      [[
        "A gunner who utilizes bullets infused with divinity to purge the world of evil. The God's Eye consumes MP to deploy Gun Skills that deal damage with tremendous power. By reaching Gun Mastery and learning a series of useful Gun skills, the God's Eye is prepared for any type of situation, especially against vampires and the undead.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gun",
        "Skills: Gun",
        "Passive: Crit +20%,Slayer Boost 100%,Gun Mastery",
        "",
      ]],
    58 => # 魔弾の射手 / Devil's Eye
      [[
        "Gunners who bargained with demons to infuse their weapons with the power of evil. By consuming HP, the Devil's Eye is able to wield forbidden Gun techniques. With an arsenal of useful skills, they can adapt to any situation including fights against Mermaids and Dragons.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gun",
        "Skills: Gun",
        "Passive: Crit +20%,Slayer Boost 100%,Gun Mastery",
        "",
      ]],
    59 => # 魔獣使い / Monster Tamer
      [[
        "Different kind of Hunter that aims to tame monster girls. Paralyzing, binding, seducing, and overall subduing their will to attack is their specialty. The mere presence of a Monster Tamer attracts other monster girls to come along for the ride.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Whip,Boomerang",
        "Skills: Scythe,Whip",
        "Passive: Recruit 150%,Slayer Boost 100%",
        "",
      ]],
    60 => # ドラゴン使い / Dragon Tamer
      [[
        "The ultimate Hunter who has learned to tame one of the most powerful monsters of all: the Dragon. The ultimate goal of the Dragon Tamer is not just to control dragons, but every type of monster that exists. The Dragon Tamer deals more damage with whips and can master powerful Whip skills, including one that deals holy damage at the cost of MP.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Whip,Boomerang",
        "Skills: Scythe,Whip",
        "Passive: Recruit 200%,Slayer Boost 100%,Whip Mastery",
        "",
      ]],
    61 => # デビルサマナー / Devil Summoner
      [[
        "A Hunter who obeys the will of darkness and uses forbidden skills to summon dark servants. The Devil Summoner can also learn Whip skills tainted by darkness that sap the user's life force.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Whip,Boomerang",
        "Skills: Scythe,Whip",
        "Passive: Recruit 200%,Slayer Boost 100%,Whip Mastery",
        "",
      ]],
    62 => # シーフ / Thief
      [[
        "Thieves make their living by taking from others, including stealing items from enemies and opening treasure chests. Other than agility, their stats are very low. Despite being poor at combat, they learn many skills useful in an adventure.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Whip,Boomerang",
        "Skills: Dagger,Throwing,Thievery",
        "Passive: Crit +10%,Eva +20%,Nullify Ambush",
        "   Preemptive Strike Up,Steal Rate 150%",
        "",
      ]],
    63 => # マスターシーフ / Master Thief
      [[
        "Expert Thief with enhanced thievery prowess. They can even steal HP and unlock green chests. More Dagger skills are acquired as well, but only as a last resort due to low fighting stats.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Whip,Boomerang",
        "Skills: Dagger,Throwing,Thievery",
        "Passive: Crit +15%,Eva +20%,Nullify Ambush",
        "   Preemptive Strike Up,Steal Rate 200%",
        "",
      ]],
    64 => # トリックスター / Trickster
      [[
        "The ultimate Thief said to possess godly skills. By mastering the art of theft, the Trickster is capable of stealing anything. The Trickster deals more damage with Dagger skills and is able to kill several enemies instantly. Nevertheless, it is important to note that Tricksters have inferior attack power compared to standard warrior jobs.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Whip,Boomerang",
        "Skills: Dagger,Throwing,Thievery",
        "Passive: Crit/Eva +20%,Nullify Ambush",
        "   Preemptive Strike Up,Steal Rate 300%,Dagger Mastery",
        "",
      ]],
    65 => # 忍者 / Ninja
      [[
        "Elusive assassin from the far East cloaked in darkness, severing lives swiftly and efficiently with Ninjutsu. Paired with dual wielding, the attack options only grow. High evasion makes up for paper-thin defenses and low attack.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Ninja Sword,Scythe,Gi",
        "Skills: Ninjutsu",
        "Passive: Crit +15%,Eva +20%,Dual Wield",
        "",
      ]],
    66 => # 極忍 / Master Shinobi
      [[
        "The ultimate Ninja who has undergone rigorous training to obtain considerable skills, including a number of lethal ninjutsu abilities. The ability to dual wield weapons makes the Master Shinobi very dangerous. Above all, it should be noted that Master Shinobi have fragile defenses.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Ninja Sword,Scythe,Gi",
        "Skills: Ninjutsu",
        "Passive: Crit/Eva +20%,Dual Wield",
        "",
      ]],
    67 => # 淫流くのいち / Erotic Kunoichi
      [[
        "The ultimate Ninja who has mastered the sexual arts, using charm and seduction to harass and subdue their targets. The Erotic Kunoichi also learns how to endure pleasure, giving them a high tolerance to sexual attacks. Because of their weak strength, the Erotic Kunoichi must rely on Dexterity and have the utmost caution in fights.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Ninja Sword,Scythe,Sex Toy,Gi",
        "Skills: Ninjutsu,Sexcraft",
        "Passive: Crit/Eva +20%,Dual Wield",
        "   Horny/Trance/Seduction Strike +5%",
        "   Incontinence Strike +5%",
      ]],
    68 => # 海賊 / Pirate
      [[
        "A proud ocean warrior who respects freedom. Pirates have excellent melee and Gun capabilities, with a high tolerance for elemental damage and status ailments. Their passionate fighting spirit enables the Pirates to reduce the SP cost of their combat skills. Armed with a plethora of offensive skills, Pirates are best suited for the front line.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Great Sword,Axe,Club,Flail,Gun",
        "Skills: Sword,Gun,Piracy",
        "Passive: Crit +10%,SP Cost 75%,Sea Strength",
        "",
      ]],
    69 => # 海賊王 / Pirate King
      [[
        "Proud Emperors of the Sea who reign over all Pirates and possess outstanding combat abilities while leaving no openings in their offense or defense. They boast high physical strength and elemental resistances and are excellent all-around survivors. Having the potential to acquire powerful skills, Pirate Kings are superior, first-rate fighters.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Great Sword,Axe,Club,Flail,Gun",
        "Skills: Sword,Gun,Piracy",
        "Passive: Crit +20%,Dual Wield,SP Cost 50%",
        "   Super Sea Strength",
        "",
      ]],
    72 => # 兵士 / Guard
      [[
        "Protects towns and castles, your average Guard. Learns skills to weaken and disable enemies. Average stats for a fighter-type, but bad with magic and not able to equip many types of weapons or armor.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Rapier,Spear,Boomerang,Armor,Helmet,Shield",
        "Skills: Sword,Spear",
        "Passive: City Strength",
        "",
      ]],
    73 => # 王宮騎士 / Royal Guard
      [[
        "Senior Guard charged with protecting top VIPs and sites. Learns more skills to further weaken foes. Attack and defense stats are fit for the offensive and are further bulked by heavy equipment.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Rapier,Spear,Heavy Spear",
        "   Boomerang,Armor,Heavy Armor,Helmet,Heavy Helmet,Shield",
        "   Heavy Shield",
        "Skills: Dagger,Sword,Rapier,Spear",
        "Passive: City Strength",
      ]],
    74 => # ナイツオブラウンド / Knight of the Round
      [[
        "Knight who has earned the highest title in the world, Knight of the Round Table. Said to boast sword skills capable of debilitating all foes at once, and can even bring forth miracles with the power of the Holy Grail. With the ability to even wield Spellblades, they are truly almighty knights.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip:Dagger,Sword,Knight Sword,Rapier,Spear,Heavy Spear",
        "   Boomerang,Armor,Heavy Armor,Helmet,Heavy Helmet,Shield",
        "   Heavy Shield",
        "Skills:Dagger,Sword,Rapier,Spear,Spellblade",
        "Passive:Super Town Strength,Sword Mastery",
        "",
      ]],
    75 => # 海兵 / Marine
      [[
        "A trained soldier of the sea who defends order and carries out justice. More robust than normal soldiers, the Marine is well suited for combat in harsh environments. Empowered by their fiery fighting spirit, Marines start the battle with more SP than normal. With additional strength in battles on the Sea, the Marine is a reliable offensive role.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Great Sword,Spear,Bow,Gun",
        "Skills: Sword,Gun,Piracy",
        "Passive: Crit +10%,Sea Strength,Battle Start SP 75%",
        "",
      ]],
    76 => # 海軍大将 / Admiral
      [[
        "A brave general of the Marine Corps, leading the other Marines into battle. The Admiral is a combat veteran with a tremendous fighting spirit, starting battle with max SP. With the might of the Armada Barrage, the Admiral mercilessly defeats any who oppose them.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Great Sword,Spear,Heavy Spear,Bow,Gun",
        "Skills: Sword,Gun,Piracy",
        "Passive: Crit +20%,Super Sea Strength,Battle Start SP 100%",
        "   Sword Mastery,Gun Mastery",
        "",
      ]],
    77 => # 正義のヒーロー / Hero of Justice
      [[
        "Strange masked warrior with a heart of justice. Stats are average all around but certain skills can only be used when transformed. Smite evildoers with all sorts of embarrassingly named attacks!",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fist",
        "Skills: Unarmed",
        "Passive: Strength in Solitude,Unyielding Fighting Spirit",
        "",
      ]],
    78 => # ジャスティスカイザー / Justice Kaiser
      [[
        "Warrior of justice who has inherited a legendary hero title. Transforming increases the Justice Kaiser's powers and unlocks the use of powerful Justice skills. Can learn many powerful skills that aren't just for show. A fearless, time-limited fighter with the power to turn the tide of battle.",
        "",
        "",
        "",
		"",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Fist",
        "Skills: Sword, Unarmed",
        "Passive: Super Strength in Solitude,Indomitable",
        "   Fighting Spirit,Sword Mastery,Fist Mastery",
        "",
      ]],
    79 => # 商人 / Merchant
      [[
        "Traveling salesmen enthusiastic about business. Increases the amount of gold acquired after battle. Not suited for combat, but nonetheless hearty and tenacious. Can purchase items in combat and use them immediately.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Boomerang,Abacus",
        "Skills: Throwing,Mercantile,EX-Item",
        "Passive: Medicine Lore I,Gold Drop 150%",
        "",
      ]],
    80 => # 闇商人 / Black Marketeer
      [[
        "Accomplished Merchant with lucrative but dubious connections. Get party members out of a jam with swift under-the-table dealings. High defense aside, direct combat is not recommended. Better items can be bought too.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Boomerang,Abacus",
        "Skills: Throwing,Mercantile,EX-Item",
        "Passive: Medicine Lore I,Gold Drop 200%",
        "",
      ]],
    81 => # 神の見えざる手 / Invisible Hand of God
      [[
        "The most efficient businessman revered as a mediator for both political and financial affairs. Able to amass a vast amount of wealth via market manipulation. With a wide variety of Mercantile skills, like purchasing rare items and immediately using them in battle, the Invisible Hand of God makes use of every advantage money can buy.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Boomerang,Abacus",
        "Skills: Throwing,Mercantile,EX-Item",
        "Passive: Medicine Lore I,Gold Drop 300%",
        "   　Abacus Mastery",
        "",
      ]],
    82 => # アイテム士 / Item User
      [[
        "Innovative user of many items and traveling faux-doctor for adventurers. The item's true essence is drawn out and divided across the party or reversed against foes. Learns Boomerang skills but otherwise powerless.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Boomerang,Abacus",
        "Skills: Throwing,Mercantile,EX-Item",
        "Passive: Medicine Lore II",
        "",
      ]],
    83 => # マスターアイテム / Item Master
      [[
        "The ultimate pharmacist who mastered the use of items. The Item Master has superior skills that can turn even the common herb into an Elixir of Wonders. The ability to provide recovery without using MP makes the Item Master essential on long journeys. Despite being lackluster in direct combat, Item Masters can still defend themselves with their Throwing skills.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Boomerang,Abacus",
        "Skills: Throwing,Mercantile,EX-Item",
        "Passive: Medicine Lore III,Boomerang Mastery",
        "",
      ]],
    84 => # 冒険家 / Adventurer
      [[
        "Classic traveler of uncharted lands. Learns skills that'll lessen the stress and dangers of long journeys. Robust, adaptable, and won't mind fighting in harsh environments. Learns a few Boomerang skills as well.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Ninja Sword,Scythe,Bow,Boomerang",
        "Skills: Dagger,Throwing,Thievery,EX-Item",
        "Passive: Crit +5%,Eva +10%,Env. Damage 50%",
        "   Desert Strength,Cave Strength",
      ]],
    85 => # レンジャー / Ranger
      [[
        "A special soldier trained to fight even in extreme environments. With training experience from both Ninjas and Pirates, Rangers can survive in any situation. Besides useful adventuring skills, Rangers can also learn powerful Throwing skills. With a Ranger in your party, you are safe in and out of combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Ninja Sword,Scythe,Bow,Boomerang",
        "Skills: Dagger,Throwing,Thievery,Ninjutsu,Piracy",
        "   EX-Item",
        "Passive: Crit/Eva +10%,Null Env. Dmg,Boomerang Mastery",
        "   Super Desert Strength,Super Cave Strength",
      ]],
    86 => # 占い師 / Fortune Teller
      [[
        "A soothsaying expert of mysterious forces. Uses tarot cards that bring out random effects. Physical stats are subpar but magic skills are passable. Besides tarot cards, many luck-based skills can be learned.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Staff,Rod,Cards",
        "Skills: Oracle",
        "Passive: Item Drop 150%,Gambling Luck I",
        "",
      ]],
    87 => # ギャンブラー / Gambler
      [[
        "Edge-teetering soothsayer gambling with fate. Disrupt the flow of battle with random events. Lady Luck may either bless your friends or empower your foes, so don't push your luck and use with caution.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Staff,Rod,Cards",
        "Skills: Oracle",
        "Passive: Crit +30%,Item Drop 200%,Gambling Luck II",
        "",
      ]],
    88 => # 闇の賭博師 / Dark Gambler
      [[
        "A legendary Gambler who has made dealings in the Underworld. With a Dark Gambler as the house, gambling can have a disastrous outcome for any and all in the game. They acquire Oracle skills that are more unpredictable, becoming more powerful and dangerous. If you want a way to turn the tide of battle, you can't ask for a better combatant.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Staff,Rod,Cards",
        "Skills: Oracle",
        "Passive: Crit +40%,Item Drop 300%,Gambling Luck III",
        "   Cards Mastery",
        "",
      ]],
    89 => # カードバトラー / Card Battler
      [[
        "Ex-Fortune Teller turned full-time card battler. Each card drawn possesses magical power that may shuffle the tide of battle. Effects range from attack to recovery. Magic may be decent, but best suited for support.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Staff,Rod,Cards",
        "Skills: Oracle",
        "Passive: None",
        "",
      ]],
    90 => # カードサマナー / Card Summoner
      [[
        "A skilled card player, who uses magic cards to summon powerful creatures. However, there is no controlling the summoned creatures for they act on their own volition. Additionally, Oracle skills have a low cost in SP and MP, allowing them to be used in quick succession. If Lady Luck smiles on you, even the toughest journeys will be nothing but cakewalks.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Staff,Rod,Cards",
        "Skills: Oracle",
        "Passive: Cards Mastery",
        "",
      ]],
    91 => # ゴッドファーザー / Godfather
      [[
        "The head of a criminal empire that rules over the Underworld. The Godfather wields two guns with great finesse and has very high combat capabilities. Acquires unique Gun skills that can effectively defeat different kinds of enemies, despite being a threat to their allies as well.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Fist,Gun",
        "Skills: Gun,Mercantile,Unarmed",
        "Passive: Counter +50%,Dual Wield,Gambling Luck III",
        "",
      ]],
    92 => # 遊び人 / Gadabout
      [[
        "A useless job, Gadabouts are inclined to goof off during battle. Not only are they poor in combat, they often interfere with other party members too. Learns singing and dancing skills, which may be useful in more advanced jobs...",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fan,Whip,Boomerang,Sex Toy",
        "Skills: Oracle,Dancing,Singing,Sexcraft",
        "Passive: Crit/Eva +20%,Gambling Luck I",
        "",
      ]],
    93 => # 踊り子 / Dancer
      [[
        "Confound and disturb the hearts of both man and monster. Learn alluring and magical dances to buff one side and debilitate the other. Has high evasion and picks up a few fan skills but due to low attack they serve as a last resort only.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Whip,Fan",
        "Skills: Fan,Dancing",
        "Passive: Eva +20%",
        "",
      ]],
    94 => # 戦巫女 / War Miko
      [[
        "A warrior who dances to bring honor to the Gods. A War Miko's dance can bring about Miracles and eliminate evil. Although they learn powerful Fan skills and boast above average magic, War Miko are not suited for direct combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Whip,Fan",
        "Skills: Fan,Dancing",
        "Passive: Eva +20%,Fan Mastery",
        "",
      ]],
    95 => # 吟遊詩人 / Minstrel
      [[
        "Vocalist whose songs shake the hearts of both man and monster. Alter the tone to awaken hidden abilities in allies. Excellent at support during drawn out battles but a poor fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Boomerang,Harp",
        "Skills: Singing",
        "Passive: Mag Eva +20%",
        "",
      ]],
    96 => # 神唱の歌姫 / Divine Songstress
      [[
        "A diva with the singing voice of God who captivates people and monsters from all over the world. A Divine Songstress' voice brings miracles to their allies and destruction to enemies. With a score of songs from attack to recovery, this singer is an encouraging ally. Their overall stats are not very high, so caution is advised.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Boomerang,Harp",
        "Skills: Singing",
        "Passive: Mag Eva +20%,Harp Mastery",
        "",
      ]],
    97 => # 娼婦 / Prostitute
      [[
        "Sexcraft specialist aiming to melt body and mind in pleasure. Inflict pleasure 'damage' with lewd skills that leave foes moist and quivering for more. While resistant against the same type of damage, don't expect anyone in this job to throw punches.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Whip,Sex Toy",
        "Skills: Sexcraft",
        "Passive: Horny/Trance Strike +5%",
        "",
      ]],
    98 => # 慈愛の聖娼 / Saintly Prostitute
      [[
        "A whore who gives affection to men and women alike, slowly leading them to ascension by ecstasy. The Saintly Prostitute learns many Pleasure skills to bring foes to ecstasy, but should avoid direct combat as much as possible.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Whip,Sex Toy",
        "Skills: Sexcraft",
        "Passive: Sex Toy Mastery,Horny/Trance Strike +5%",
        "   Incontinence Strike +5%",
        "",
      ]],
    99 => # 傾国の魔娼 / Devilish Prostitute
      [[
        "A whore who captivates the hearts of men and women with the movements of their fingers and takes their soul away through sexual ruin. The Devilish Prostitute learns many Pleasure skills to bring foes to temptation, but should avoid direct combat as much as possible.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Whip,Sex Toy",
        "Skills: Sexcraft",
        "Passive: Sex Toy Mastery,Horny/Trance Strike +5%",
        "   Seduction Strike +5%",
        "",
      ]],
    100 => # スーパースター / Superstar
      [[
        "Singing, dancing, and all-around captivating idol. Distract foes with songs while allies are encouraged by dances. Special stage skills can be learned as well. Support capabilities are virtually peerless.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Whip,Harp,Fan",
        "Skills: Fan,Dancing,Singing",
        "Passive: Eva/Mag Eva +15%,Seduction Strike +20%",
        "",
      ]],
    101 => # バトルファッカー / Battle Fucker
      [[
        "Lewd fighter who incorporates sex acts into battle. The foe's privates are erotically tortured by hands, feet, and other body parts. Apart from greater resistance against pleasure-based attacks, new abilities increase the odds of addling foes into a rapturous stupor.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Whip,Fist,Sex Toy",
        "Skills: Whip,Unarmed,Sexcraft",
        "Passive: Crit +15%,Eva +10%,Horny/Trance Strike +5%",
        "",
      ]],
    102 => # クイーンファッカー / Queen Fucker
      [[
        "Queen of sex battles who reigns supreme over all Battle Fuckers. Can make any opponent instantly ascend to heaven with powerful and unparalleled pleasure techniques. Highly resistant to pleasure attacks and pleasure status ailments. Displays unmatched power against monsters weak to pleasure.",
        "",
        "",
        "",
		"",
      ],
      [
        "Equip: Whip,Fist,Sex Toy",
        "Skills: Whip,Unarmed,Sexcraft",
        "Passive: Sex Toy Mastery,Horny/Trance Strike +5%",
        "   Seduction/Incontinence Strike +5%",
        "",
      ]],
    103 => # 学者 / Scholar
      [[
        "Ambitious student on the pursuit of truth. Utilizes a new form of magic to fend off enemies. This type of magic uses SP as opposed to MP, making it a versatile skill set useful in future jobs.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Rod,Scalpel,Grimoire,Gun",
        "Skills: Magic Science,Alchemy,Grimoire",
        "Passive: None",
        "",
      ]],
    104 => # 魔導学者 / Magical Scholar
      [[
        "Scholar fully immersed in the next level of magic science, mixing and matching various compounds to wreak havoc upon Dolls and other artificial monsters. The conversion rate between SP and MP has increased as well.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Rod,Scalpel,Grimoire,Gun",
        "Skills: Magic Science,Alchemy,Grimoire",
        "Passive: None",
        "",
      ]],
    105 => # マスターアルケミスト / Master Scholar
      [[
        "The ultimate scholar of Magic Science. The Master Scholar is able to harness the extreme power of science to cause destruction indistinguishable from the effects of magic. They can efficiently make use of both SP and MP, making them just as proficient at casting magic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Rod,Scalpel,Grimoire,Gun",
        "Skills: Magic Science,Alchemy,Grimoire",
        "Passive: Magic Mastery",
        "",
      ]],
    106 => # 錬金術士 / Alchemist
      [[
        "A scholar who explored the ability to create items out of thin air by refining objects into mysterious alchemical tools. Items created by the Alchemist's skills are immediately used upon creation. The Alchemist performs well as an offensive spellcaster with stats similar to that of a mage.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Staff,Rod,Grimoire",
        "Skills: Magic Science,Alchemy,Grimoire",
        "Passive: Turn End Reagent Auto-Collect 50%",
        "",
      ]],
    107 => # 錬金宝貝士 / Golden Alchemist
      [[
        "The ultimate Alchemist who combines items and alchemical reagents to craft rare and mysterious weapons and armors. The refined equipment can only be utilized once in battle, but its power is extremely useful. Although Golden Alchemists are not suited for combat, the power of legendary weapons shouldn't be underestimated.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Staff,Rod,Grimoire",
        "Skills: Magic Science,Alchemy,Grimoire",
        "Passive: Turn End Reagent Auto-Collect 50%",
        "   Magic Mastery",
      ]],
    108 => # 魔導司書 / Magical Librarian
      [[
        "Scholar and researcher of magical books. By sacrificing a page of the grimoire, a powerful phenomenon occurs at no extra cost. Besides the basic elements, the pages contain spells for every occasion...if you have enough to spare.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Staff,Rod,Grimoire",
        "Skills: Magic Science,Alchemy,Grimoire",
        "Passive: None",
        "",
      ]],
    109 => # ロードライブラリ / Library Lord
      [[
        "The ultimate magic scientist who wields the power of grimoires. By consuming a page from the grimoire, the Library Lord can activate powerful magical skills, including recovery and support spells. Be sure to keep stock of grimoire pages.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Staff,Rod,Grimoire",
        "Skills: Magic Science,Alchemy,Grimoire",
        "Passive: Magic Mastery",
        "",
      ]],
    110 => # 技師 / Engineer
      [[
        "Job that uses cutting-edge weaponry to dispatch whole swaths of enemies. Despite the boost in SP its general status still falls short of the more traditional combat-oriented jobs.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Club,Gun",
        "Skills: Makina",
        "Passive: None",
        "",
      ]],
    111 => # マキナマイスター / Machinist
      [[
        "Advanced engineer skilled with higher-grade tech, wielding their destructive power in the heat of battle. Some makina are designed to explicitly mow down certain types of enemies, while others are aligned towards self-defense.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Club,Gun",
        "Skills: Makina",
        "Passive: None",
        "",
      ]],
    112 => # マスターマシーナリー / Makina Master
      [[
        "The ultimate engineer who has learned to wield various Makina. With mastery over every kind of Makina, this combatant can hold back hordes of enemies. With high stats and the right weapon equipped, Makina Masters will outmatch even the strongest of warriors.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Club,Gun",
        "Skills: Makina",
        "Passive: Gun Mastery",
        "",
      ]],
    113 => # 魔芸師 / Spiritualist
      [[
        "Novice necromancer who seeks mastery of the three arts. Learns a few fledgling skills of each school and armed with high magic stats. As a branch of the Summoning arts, this job must be mastered in order to settle into a true profession.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Scythe,Rod,Whip,Grimoire,Robe,Magic Hat",
        "Skills: Scythe,Summoning",
        "Passive: None",
        "",
      ]],
    114 => # ネクロマンサー / Necromancer
      [[
        "Unique summoner that turns corpses into minions fueled by life. Countless experiments with many bodies indirectly allows for the dubious use of Medicine skills as well. Juggle syringes and impromptu graverobbing effectively for complete reliability.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Scythe,Rod,Whip,Scalpel,Grimoire,Robe,Magic Hat",
        "Skills: Scythe,Summoning,Medicine,Corpse",
        "Passive: None",
        "",
      ]],
    115 => # ネクロマスター / Necromaster
      [[
        "The ultimate Necromancer who can skillfully manipulate powerful zombies and summon legendary Yomas. With additional knowledge of medicine, the Necromaster is a useful combat medic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Scythe,Rod,Whip,Scalpel,Grimoire,Robe,Magic Hat",
        "Skills: Scythe,Summoning,Medicine,Corpse",
        "Passive: Magic Mastery",
        "",
      ]],
    116 => # 降霊術師 / Medium
      [[
        "Unique summoner that calls ghosts from the afterlife lured by mana. With a few nibbles of the Medium's MP, they'll fight alongside the party and even impart life in return. Black Magic is a less costly alternative, provided that there's MP to spare.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Scythe,Staff,Rod,Grimoire,Robe,Magic Hat",
        "Skills: Scythe,Black Magic,Summoning,Corpse",
        "Passive: None",
        "",
      ]],
    117 => # マスターシャーマン / Master Shaman
      [[
        "The ultimate shaman who can summon legendary spirits both living and dead. With mighty Summoning skills and high magic power, the Master Shaman is an outstanding ally to have.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Scythe,Staff,Rod,Grimoire,Robe,Magic Hat",
        "Skills: Scythe,Black Magic,Summoning,Corpse",
        "Passive: Magic Mastery",
        "",
      ]],
    118 => # からくり人形師 / Puppeteer
      [[
        "Unique summoner that controls dolls built from scratch with great care. Controlling the dolls takes neither magic nor life, but very high concentration to perform well. Ergo, Makina serve as a viable backup.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Scythe,Rod,Grimoire,Gun,Robe,Magic Hat",
        "Skills: Scythe,Summoning,Makina,Artificial",
        "Passive: None",
        "",
      ]],
    119 => # マスタードーラー / Puppet Master
      [[
        "The ultimate Puppeteer who manipulates dolls as powerful weapons. By wielding Artificial and Makina skills, the Puppet Master is a powerful attacker.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Scythe,Rod,Grimoire,Gun,Robe,Magic Hat",
        "Skills: Scythe,Summoning,Makina,Artificial",
        "Passive: Magic Mastery",
        "",
      ]],
    120 => # 情報屋 / Informant
      [[
        "Words become weapons in this unorthodox job. Distract the enemy with stories and idle gossip. Despite subpar efforts in both forms of combat, this job is invaluable for gathering more allies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Boomerang,Gun",
        "Skills: Throwing,Talk",
        "Passive: None",
        "",
      ]],
    121 => # 話術士 / Smooth Talker
      [[
        "A skilled wordsmith who fights without throwing a punch. Suave fast-talking can coax money and items from foes. Failing that, colorful phrases can induce abnormal status. Not fit for fighting and would prefer to use words as weapons.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Boomerang,Gun",
        "Skills: Throwing,Talk",
        "Passive: None",
        "",
      ]],
    122 => # 話神 / God of Speech
      [[
        "The ultimate informant whose mastery of speech approaches the realm of magic. Capable of uttering blessings to revive an ally, or cursing opponents with instantaneous death. Naturally, they are adept at quickly building friendships with their enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Boomerang,Gun",
        "Skills: Throwing,Talk",
        "Passive: Boomerang Mastery",
        "",
      ]],
    123 => # 料理人 / Cook
      [[
        "Devoted foodie in pursuit of unique recipes. Skilled hands and a passionate heart craft splendid meals in the heat of battle, buffing allies and smiting foes. Completed dishes are stored in the inventory.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Kitchen Knife",
        "Skills: Dagger,Cooking",
        "Passive: None",
        "",
      ]],
    124 => # トリプルコック / Three Star Chef
      [[
        "Master chef capable of whipping out divine meals. The recipe list is expanded with cuisines that dish out spectacular effects on the tongue and battlefield. Kitchen knives are handy in a pinch, but are unreliable compared to real weapons.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Kitchen Knife",
        "Skills: Dagger,Cooking",
        "Passive: None",
        "",
      ]],
    125 => # 味皇 / Flavor Emperor
      [[
        "Masters of the culinary arts who have become recognized as gods of cooking, with first-class recipes that restore the party's vitality. The Flavor Emperor can apply unique support effects and buffs, and is able to create dishes even without the necessary ingredients.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Scythe,Kitchen Knife",
        "Skills: Dagger,Cooking",
        "Passive: Kitchen Knife Mastery",
        "",
      ]],
    126 => # ナース / Nurse
      [[
        "Assistant doctor armed with basic first aid. Mend wounds, inoculate against status ailments, and improve general health with skills based on SP. Speed and dexterity are decent, but subpar for the front lines.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Staff,Scalpel",
        "Skills: Dagger,Medicine",
        "Passive: Eva +10%",
        "",
      ]],
    127 => # 医者 / Doctor
      [[
        "Accomplished battle physician fully loaded with the basics. Mends wounds without the use of items or magic. Even resuscitation is possible without using a hint of mana. Overall, an acceptable substitute for a White Mage when MP support is low.",
        "",
        "",
        "",
        "",
	  ],
      [
        "Equip: Staff,Scalpel",
        "Skills: Dagger,Medicine",
        "Passive: Eva +10%",
        "",
      ]],
    128 => # 神医 / Godly Doctor
      [[
        "Legendary doctors who have mastered Eastern and Western medicine, able to treat their patients with flawless healing skills. With the ability to grant immunities to abnormal statuses and instant death, Godly Doctors are the perfect healers.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Staff,Scalpel",
        "Skills: Dagger,Medicine",
        "Passive: Eva +10%,Scalpel Mastery",
        "",
      ]],
    129 => # メイド / Maid
      [[
        "Dutifully performs household tasks with utmost care. Improvises housekeeping skills for combat to support allies and cripple enemies. Uses special skills to eliminate pesky bugs and weeds.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Whip,Fan,Plate,Sex Toy",
        "Skills: Whip,Service",
        "Passive: Eva/Mag Eva +10%",
        "",
      ]],
    130 => # マスターメイド / Master Maid
      [[
        "An expert maid that provides service without delay. In addition to keeping allies cozy, maids of this caliber can jump into the fray with secret self-defense techniques. Also obtains an ability that boosts job XP acquisition.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fan,Whip,Plate,Sex Toy",
        "Skills: Whip,Service",
        "Passive: Eva/Mag Eva +10%",
        "",
      ]],
    131 => # パーフェクトメイド / Perfect Maid
      [[
        "The ultimate maid who is ranked above all other maids, using flawless Service skills to fully support allies. The Perfect Maid's sexual skills are also outstanding, bringing enemies to ascension through service. They have also mastered strong Service skills, and cannot be beaten on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fan,Whip,Plate,Sex Toy",
        "Skills: Whip,Service",
        "Passive: Eva/Mag Eva +10%,Plate Mastery",
        "",
      ]],

    134 => # 貴族 / Noble
      [[
        "Members of the nobility who appear on the battlefield to fulfill the obligations that accompany their high-born status. Use rapiers and rapier skills along with abilities to increase XP and recover HP automatically. Good in combat with overall high stats.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Rapier,Bow",
        "Skills: Dagger,Rapier,Ruling",
        "Passive: Eva +10%,HP Regen +5%",
        "",
      ]],
    135 => # 王 / King
      [[
        "Unequaled ruler of an entire country. Capable of taking control of the battlefield while fighting on the front lines. Fierce with a sword imbued with secret techniques. Heavy equipment can also even the odds.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Rapier,Spear,Heavy Spear,Bow",
        "   Armor,Heavy Armor,Helmet,Heavy Helmet,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Rapier,Ruling",
        "Passive: Crit +10%,HP Regen +10%",
        "",
      ]],
    136 => # 騎士王 / King of Knights
      [[
        "A king among kings who has mastered the art of war. The King of Knights' military prowess is said to be on par with a thousand soldiers. Can master extremely powerful skills passed down only within the royal family. Can learn many very useful abilities.",
        "",
        "",
        "",
		"",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Great Sword,Rapier,Spear",
        "   Heavy Spear,Bow",
        "Skills: Dagger,Sword,Rapier,Ruling",
        "Passive: HP Regen +20%,Sword Mastery",
        "",
      ]],
    137 => # 魔導王 / Magus King
      [[
        "A Warrior born from a bloodline of Kings naturally gifted to wield all manner of magic. The Magus King boasts powerful magic resistance, which cuts elemental damage in half. Having mastered all forms of magic, the Magus King is a force to be reckoned with.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Magic Sword,Staff,Rod,Grimoire,Robe,Magic Hat",
        "Skills: White Magic,Black Magic,Time Magic,Summoning",
        "   Magic Science,Alchemy,Grimoire,Ruling",
        "Passive: Mag Eva +20%,MP Regen +4%,Magic Mastery",
        "",
      ]],
    138 => # 法王 / Pope
      [[
        "Traveling minister preaching the good word across the world. Dutiful prayers call upon miracles to heal allies and smite enemies at the Goddess' behest. Good tidings shall come to those who bring a Pope along.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Magic Sword,Club,Staff,Grimoire,Robe,Magic Hat",
        "Skills: White Magic,Holy,Ruling",
        "Passive: Mag Eva +20%,Mag Ref +30%",
        "",
      ]],
    139 => # 神聖法王 / Sacred Pope
      [[
        "Great Master considered the closest to the Goddess among all the succeeding Popes. With outstanding miracles that shine even brighter, a Sacred Pope can share divine revelations with their companions. Can call forth crusades and even bring about the apocalypse. Shines not only as a healer, but also as a magic attacker.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Magic Sword,Club,Staff,Grimoire",
        "Skills: White Magic,Holy,Ruling",
        "Passive: Magic Reflect +50%,Magic Mastery",
        "",
      ]],
    140 => # 機甲法王 / Armored Pope
      [[
        "Military Pope who believes in firepower and armor above all. Uses exclusive weapons developed in secret and silences the enemies of the Goddess with firepower. Has mastered all manner of Makina and is well versed in mechanical technology from all over the world. The Armored Pope's ferocious appearance as they go to the front lines with their weapons is divine.",
        "",
        "",
        "",
		"",
		"",
      ],
      [
        "Equip: Dagger,Magic Sword,Club,Staff,Grimoire,Gun",
        "Skills: Gun,White Magic,Makina,Ruling",
        "Passive: Magic Reflect +50%,Gun Mastery",
        "",
      ]],
    141 => # 見習い勇者 / Apprentice Hero
      [[
        "A hero-in-training who has not received the blessing of the Goddess. Aims to be a true hero, wields a sword but without experience. Average stats, poor at magic. Has personal sword skills and minor divine protection.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Rapier,Spear,Axe,Club,Scythe,Boomerang",
        "   Armor,Helmet,Shield",
        "Skills: Dagger,Sword,Heroism",
        "Passive: None",
        "",
      ]],
	142 => # 勇者 / Hero
      [[
        "A genuine hero blessed by the Goddess Ilias. Few in number, these sanctified warriors purge spirits and demons with blazing techniques, reducing them to ashes. Many stats are well above average and worthy of the title.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Knight Sword,Rapier,Spear,Axe,Club,Scythe",
        "   Boomerang,Armor,Heavy Armor,Helmet,Heavy Helmet,Shield",
        "   Heavy Shield",
        "Skills: Dagger,Sword,Heroism",
        "Passive: Crit +10%,SP Regen +10%",
        "",
      ]],
    143 => # 光の勇者
      [[ "A hero among heroes granted the power of light by the Goddess of Creation Their SKL even contain holy power allowing no monsters to exist Their stats are overwhelming displaying superior power in any situation Their learned abilities are extremely useful making them the main force on the battlefield",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Sword, Knight Sword, Great Sword, Rapier, Spear, Heavy Spear, Axe, Club, Scythe, Boomerang, Skill: Dagger, Sword, Holy, Heroism, Passive: Holy Technique Power +30%, Recover 20% SP every turn, Sword Mastery+"
]],
    144 => # 闇の勇者
      [[ "A hero of betrayal and depravity granted the power of darkness by the Dark Goddess Their sword not aligning with the Goddesss will is imbued with dark power bringing destruction Their stats are overwhelming displaying superior power in any situation Their learned abilities are extremely useful making them the main force on the battlefield",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Sword, Knight Sword, Great Sword, Rapier, Spear, Heavy Spear, Axe, Club, Scythe, Boomerang, Skill: Dagger, Sword, Dark, Heroism, Passive: Dark Technique Power +30%, Recover 20% SP every turn, Sword Mastery+"
]],
    149 => # 無職 / Unemployed
      [[
        "Unemployed bum with no job. There are no advantages or skills associated with being unemployed. Mastering it does nothing, either.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger",
        "Skills: None",
        "Passive: None",
        "",
      ]],
    6998 => # 野生児 / Feral Youth
      [[
        "A wild child who fights weaponless, using only their body to unleash pure, untamed power. Excels at monster techniques and has impressive attack and agility. Poorly suited to magic and low on defense, so caution is necessary. Ideal for those who wish to make monster skills the primary weapon in battle.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fangs",
        "Skills: All Racial Skills",
        "Passive: Racial Skill Booster 15%, Critical Rate +15%",
        "",
      ]],
    6999 => # 魔物魂 / Monster Soul
      [[
        "A physical expert who has mastered the art of monster skills. Inflicts heavy damage using monster skills alone and boasts exceptionally high attack and agility. Ill-suited to wielding weapons or using magic, but can learn numerous abilities to significantly boost the potency of monster skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fangs",
        "Skills: All Racial Skills",
        "Passive: Racial Skill Booster 30%, Critical Rate +20%",
        "",
      ]],
    7000 => # ワイルドハート / Wildheart
      [[
        "A top-class expert who has mastered the art of monster skills. Elevates monster skills to devastating levels with overwhelming attack and agility. Incapable of using weapons other than fangs or wielding magic. A pure specialist in monster techniques, unleashing unparalleled strength when focused solely on them.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fangs",
        "Skills: All Racial Skills",
        "Passive: Racial Skill Booster 50%, Fang Mastery,",
        "  Critical Rate +20%",
      ]],
    7001 => # エスパー / Esper
      [[
        "A job with skills that allow the user to master Psychokinesis and freely use it in battle. Although it has become an abandoned job, it is said to be the origin of Magic Swords. Telekinetic attacks negate the opponent's defenses and are impossible to avoid. And since they have no attribute, they are unaffected by the enemy's resistances.",
        "",
        "",
        "",
        "",
        ""
      ],
      [
        "Equip: Magic Sword,Rod,Sex Toy",
        "Skills: Sword,Black Magic,Psychic,Sexcraft",
        "Passive: MP Regen 1%",
      ]],
    7002 => # ハイサイキック / High Psychic
      [[
        "An Esper with enhanced psychic power. Due to their extraordinary psychokinetic power, they can overwhelm their enemies without even touching them. Telekinetic attacks negate the opponent's defenses and are impossible to avoid. This job has good compatibility with pleasure attacks and is easy to use with a variety of attribute skills.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Magic Sword,Rod,Sex Toy",
        "Skills: Sword,Black Magic,Psychic,Sexcraft",
        "Passive: MP Regen 2%",
      ]],
    7003 => # サイコソルジャー / Psycho Soldier
      [[
        "The ultimate psychic warrior, combining psychokinetic power and combat skills. It is said that during the time of the Great Monster Wars, only a few elites had mastered this job. Telekinetic attacks negate the opponent's defenses and are impossible to avoid. Excels in both attack and defense and can flexibly deal with any situation.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Magic Sword,Rod,Sex Toy",
        "Skills: Sword,Black Magic,Psychic,Sexcraft",
        "Passive: MP Regen 4%,Sword Mastery,Sex Toy Mastery",
      ]],
    7004 => # フェンサー / Fencer
      [[
        "A fleet-footed warrior wielding a rapier with ease and whose speed is their greatest weapon. Has a noble spirit that inspires them to battle against the strong. Can automatically recover SP with the use of rapiers, making them able to fight for extended periods. However, they are very vulnerable to attacks and need to fight with utmost caution.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Rapier,Spear",
        "Skills: Rapier",
        "Passive: Physical Reflect +10%, Boss Slayer 10%",
      ]],
    7005 => # ノーブルフェンサー / Noble Fencer
      [[
        "A noble warrior who has mastered the art of the rapier. Their noble spirit heightens their ability to battle the strong. Can learn a variety of abilities suited to the handling of the rapier. Their speed allows them to attack in rapid succession, but their defense is brittle.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Rapier,Spear",
        "Skills: Rapier",
        "Passive: Physical Reflect +30%, Boss Slayer 30%,Rapier Mastery",
      ]],
    7006 => # 妖術師 / Sorcerer
      [[
        "A spellcaster who recreates techniques used by monsters with their own life energy. Some skills used by enemies can be learned by seeing them in battle. Learned skills can be used as sorcery in subsequent battles. Sorcery has a variety of special effects and can be used in many situations.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Magic Sword,Fist,Scythe,Staff,Rod,Fan",
        "Skills: Sorcery",
        "Passive: Learning",
      ]],
    7007 => # 異界妖術師 / Nether Sorcerer
      [[
        "A master Sorcerer who has further enhanced their ability to manipulate life energy. Can use learned skills and powerful techniques in battle. Their stats are all high and they have no major weaknesses. By using the special effects of various techniques with Sorcery, they can deal with any situation.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Magic Sword,Fist,Scythe,Staff,Rod,Fan",
        "Skills: Sorcery",
        "Passive: Learning,Scythe Mastery",
      ]],
    7008 => # シールドナイト / Shield Knight
      [[
        "A knight skilled in the use of shields, with excellent defensive abilities. Has the power to reflect or neutralize attacks before striking back. They can not only protect themselves, but also defend and heal their allies. Can also learn a skill to throw their shield at the enemy, but it's not very powerful.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Dagger,Sword,Rapier,Spear,Boomerang,Heavy Armor",
        "Skills: Throwing",
        "Passive: Endure,Appeal",
      ]],
    7009 => # キャプテンシールド / Captain Shield
      [[
        "A hero renowned for their mastery of the shield. Has a unique style of equipping shields with both hands and is extremely strong. Their various defensive skills make them the guardian of the party. Can also convert their defense into attack and enhance their throwing skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Heavy Armor",
        "Skills: Throwing",
        "Passive: Double Shield,Super Endure",
        "　　　　　　Super Appeal,Shield Mastery",
      ]],
    7011 => # 究極剣士
      [[ "The ultimate swordsman who has integrated the holy sword and the demon sword reaching the heights of chaos Excels in ATK and DEF superior in close combat SKL and has above-average agility Capable of dealing with both single and multiple enemies demonstrating power in any situation A high-level and stable warrior with no noticeable weaknesses",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Sword, Knight Sword, Great Sword, Pointed Sword, Katana, Skill: Sword, Katana, Magic Sword, Passive: Can Equip Heavy Armor, Sword/Katana Mastery+"
]],
    7012 => # フォースマスター
      [[ "A magic warrior who has mastered the power of sorcery and Taoism reaching the realm of chaos That magic sword can also handle higher chaos attributes Additionally it learns abilities that allow the activation of Black Magic and Taoism following sword SKL A highly versatile warrior with attacks in both sword SKL and magic",
  "",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Sword, Pointed Sword, Magic Sword, Katana, Scythe, Rod, Fan, Skill: Sword, Black Magic, Taoism, Magic Sword, Passive: Can Equip Light Armor, Absolute Magic Counter, Sword Mastery+, Activate Higher Chaos Attributes with Magic Sword"
]],
    7013 => # 神竜の騎士
      [[ "A divine Dragoon who has mastered both light and darkness reaching the brink of chaos Spear SKL unleashed with overwhelming speed silence enemies instantly The acquired ability 'Ahead of the Game' increases damage by 50% when attacking first. Additionally they can master the ultimate spear technique imbued with the power of the galaxy.",
  "",
  "",
  "",
  "",
],
[
  "Equip: Spear, Heavy Spear, Skill: Spear, Passive: Heavy Armor Proficiency, Spear Mastery+"
]],
    7014 => # 修羅
      [[ "An ultimate samurai who has mastered both holy and dark even wielding the power of chaos. Learns SKL with Ashura attribute a higher form of chaos physical attribute. Additionally they can acquire abilities to activate sword SKL following katana SKL. While their defense has gaps their offensive capabilities are overwhelming.",
  "",
  "",
  "",
  "",
],
[
  "Equip: Katana, Skill: Katana, Passive: Katana Mastery+"
]],
    7015 => # メテオブレイカー
      [[ "The ultimate chaotic heavy warrior who masters clubs axes and flails Their strength is unparalleled capable of destroying even asteroids Though poor with magic they boast overwhelming power and defense Learns powerful SKL and many attack-specialized abilities",
  "",
  "",
  "",
  "",
],
[
  "Equip: Great Sword, Axe, Club, Flail, Skill: Axe, Club, Flail, Passive: Super Endure, Can Equip Heavy Armor, Power Mastery+, Double SP Charge"
]],
    7016 => # 拳神
      [[ "A peerless martial artist who has mastered both holy and dark fists reaching the realm of chaos Boasts overwhelming ATK and agility annihilating enemies first Extremely high counter rate with excellent critical rate and evasion Although there are weaknesses in defense the specialization in quick attacks is very reassuring",
  "",
  "",
  "",
  "",
],
[
  "Equip: Fist, Club, Skill: Unarmed, Passive: Perfect Counter, Perfect Magic Counter, Can Equip Unarmed Gi, Fist Mastery+"
]],
    7017 => # 神の守護者
      [[ "The ultimate warrior who serves the gods with great faith Extremely high Unarmed performance and excellent defensive capabilities Also proficient in holy SKL and capable of performing miracles by sacrificing oneself Excels in both offense and defense making them a very reliable presence",
  "",
  "",
  "",
  "",
],
[
  "Equip: Fist, Club, Staff, Skill: Unarmed, White Magic, Holy, Passive: Holy Technique Power +50%, Can Equip Gi, Fist Mastery+"
]],
    7018 => # 終焉魔導師
      [[ "A mage who has mastered Black Magic and finally stepped into the realm of chaos Learns extremely powerful Black Magic and can handle the Apocalypse attribute Can also learn various abilities to enhance attack magic Poor at physical attacks and has low DEF so caution is necessary",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Magic Sword, Scythe, Rod, Grimoire, Skill: Black Magic, Dark, Passive: Dark Technique Power +50%, Can Equip Magic Armor, Magic Mastery+"
]],
    7019 => # 銀河魔導師
      [[ "The ultimate time mage who has finally gained control over the movements of the galaxy Supports battles with powerful time magic and can also use galaxy attribute attack magic The galaxy attribute belongs to the realm of chaos and most enemies have no resistance to it making it extremely powerful A very powerful mage who does not fall short even in offensive capabilities",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Magic Sword, Scythe, Rod, Grimoire, Skill: Time Magic, Passive: Can equip magical armor, +Magic Mastery"
]],
    7020 => # 混沌召喚士
      [[ "A forbidden summoner with the ability to summon chaotic entities The summoned chaotic entities deal overwhelming damage to all enemies However be cautious of the large MP consumption Can also learn several powerful abilities suitable for summoning",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Magic Sword, Scythe, Rod, Grimoire, Skill: Summoning, Passive: Can equip magical armor, +Magic Mastery"
]],
    7021 => # 太極陰陽師
      [[ "The ultimate Taoism who has mastered Taoism SKL reaching the realm of chaos Learns Terra and Galaxy attribute SKL dealing exceptional damage As a mage their stats outside of magic power are not low allowing them to handle various situations Abilities that activate summoning from Taoism are also powerful and greatly enhance combat strength",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Scythe, Magic Sword, Rod, Fan, Skill: Taoism, Passive: Can Equip Magical Armor, Magic/Fan Mastery+"
]],
    7022 => # 永劫魔導師
      [[ "A White Mage who has mastered White Magic and reached the realm of chaos Learns Eternal attribute attack magic excelling in offensive capabilities Learns multiple excellent healing SKL capable of excelling in both offense and defense Abilities also enhance white magic boasting top performance as a healer",
  "",
  "",
  "",
  "",
],
[
  "Equip: Staff, Whip, Wand, Magic Book, Skill: White Magic, Holy, Passive: Greatly Enhance Holy, Equippable with Magic Armor, Magic Mastery+"
]],
    7023 => # ソーサラースプリーム
      [[ "A transcendent being said to stand at the pinnacle of magicians Masters all forms of magic including White Magic Black Magic and Time Magic Also capable of using multiple Chaos attributes with overwhelming offensive power As the highest-ranking magician exhibits unparalleled strength",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Magic Sword, Club, Scythe, Whip, Staff, Rod, Fan, Magic Book, Skill: White Magic, Black Magic, Time Magic, Summoning, Holy, Dark, Taoism, Passive: Holy and Dark Techniques Power +50%, MP consumption halved, can equip magic armor, Magic Mastery+"
]],
    7024 => # アルティメット魔法少女
      [[ "The strongest magical girl who has obtained ultimate power Their magic even reaches chaos capable of using Eternal and Galaxy attributes Learns multiple useful magical abilities in addition to powerful attack SKL When transformed their abilities increase by 50% making them exceptional as a Magic Hero.",
  "",
  "",
  "",
  "",
],
[
  "Equip: Magic Sword, Scythe, Staff, Rod, Bow and Arrow, Grimoire, Gun, Skill: White Magic, Black Magic, Time Magic, Holy, Passive: Holy Technique Power +50%, Recover 6% MP every turn, Can Equip Magic Armor, Magic Mastery+"
]],
    7025 => # 狩神
      [[ "The ultimate hunter who possesses both holy and dark powers Their arrows even carry the power of chaos allowing them to learn Hadron attribute bow SKL They have extremely high agility and accuracy allowing them to take the initiative and eliminate enemies They have powerful racial special attack effects and while their defense is low they boast high extermination power",
  "",
  "",
  "",
  "",
],
[
  "Equip: Scythe, Bow and Arrow, Whip, Boomerang, Skill: Scythe, Bow, Whip, Throwing, Passive: Enhanced Racial Special Attacks, Bow Mastery+, Forest Super Enhancement"
]],
    7026 => # 銃神
      [[ "An invincible gunner who has mastered both holy and dark guns reaching the realm of chaos Learns Hadron attribute gun SKL demonstrating exceptional offensive capabilities Learns useful abilities that greatly enhance the power of gun SKL While their other abilities are low their offensive capabilities more than make up for it",
  "",
  "",
  "",
  "",
],
[
  "Equip: Gun, Skill: Gun, Passive: Enhanced Racial Special Attacks, Gun Mastery+"
]],
    7027 => # カオスバスター
      [[ "A forbidden monster tamer who can even subdue chaotic entities Can summon Apoptosis and wield overwhelming power Learns top-tier whip SKL and wields a whip imbued with chaos attributes Possesses anti-Apoptosis capabilities making them strong against chaotic beings",
  "",
  "",
  "",
  "",
],
[
  "Equips: Scythe, Whip, Boomerang, Skill: Scythe, Whip, Passive: 5x Ally Chance, Species Special Attack Enhancement, Whip Mastery+"
]],
    7028 => # パーフェクトアームズ
      [[ "An all-rounder who SKLfully handles various weapons as if they were extensions of their body Boasts top-tier proficiency with all weapons from close combat to shooting Wields weapons in both hands and overwhelms enemies with powerful barrage SKL Additionally the Barrage ability greatly enhances normal attacks",
  "",
  "",
  "",
  "",
],
[
  "Equip: All Weapons, Skill: Dagger, Sword, Rapier, Katana, Spear, Axe, Club, Scythe, Bow, Whip, Throwing, Flail, Fan, Gun, Multi-Weapon, Passive: Barrage, Dual Wield"
]],
    7029 => # 盗神
      [[ "A forbidden thief said to have reached the realm of chaos with their SKL Learns various SKL related to thievery and has extremely high agility and evasion The chain that allows the activation of thievery SKL immediately after dagger SKL is also extremely powerful However they are not suited for direct combat and are not fit for offensive roles",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Scythe, Whip, Boomerang, Skill: Dagger, Throwing, Thievery, Passive: Treasure Hunt 3, Nullify Ambush, Preemptive Strike Up, Dagger Mastery+"
]],
    7030 => # 忍神
      [[ "A forbidden ninja who has mastered all ninjutsu and reached the realm of chaos Can learn Terra attribute ninjutsu and the ultimate pleasure ninjutsu Also learns SKL to enhance dual wielding with extremely high offensive capabilities Defense is low so caution is needed to avoid taking hits",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Ninja Sword, Scythe, Sex Toy, Skill: Ninjutsu, Passive: Dual Wield, Can Equip Unarmed Gi"
]],
    7031 => # 七海覇王
      [[ "A pirate king who is also the head of the navy truly the ruler of the seven seas Wields powerful pirate SKL crushing enemies with overwhelming force Their basic abilities are extremely high demonstrating unparalleled power in direct combat. They also have the ability to exceed the maximum SP value at the start of combat.",
  "",
  "",
  "",
  "",
],
[
  "Equip: Daggers, Swords, Knight Swords, Great Swords, Guns, Skill: Sword, Gun, Pirate, Passive: SP Consumption 1/2, Initial SP 130%, Dual Wielding, Enhanced Sea Power"
]],
    7032 => # エクセルシオール
      [[ "A hero among heroes who has become a legend. The increase in abilities upon transformation is extremely high demonstrating unparalleled power. The hero SKL they learn have overwhelming power mowing down swarming enemies. Aim for even greater heights!",
  "",
  "",
  "",
  "",
],
[
  "Equip: Daggers, Swords, Knight Swords, Fists, Skill: Sword, Unarmed, Passive: Super Strength in Solitude, Super Indomitable Fighting Spirit, Sword/Fist Mastery+"
]],
    7033 => # 商神
      [[ "The god of commerce who reigns over the world with immense wealth Excels in using top-tier mercantile SKL and handling items The acquired procurement SKL can obtain chaotic items Surprisingly high defense but not suited for direct combat so caution is needed",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Scythe, Boomerang, Abacus, Skill: Throwing, Mercantile, EX-Item, Passive: 4x Gold Acquisition, Medicine Lore III, Boomerang/Abacus Mastery+"
]],
    7034 => # ラストサバイバー
      [[ "The ultimate survivor who can live through any situation Has high overall stats except for magic excelling in survival abilities Also capable of learning convenient abilities such as significant recovery after victory While not overwhelmingly strong its a job that proves useful by surviving",
  "",
  "",
  "",
  "",
],
[
  "Equip: Daggers, Ninja Swords, Scythes, Bows and Arrows, Boomerangs, Skill: Dagger, Throwing, Thievery, Ninjutsu, Pirate, EX Items, Passive: Floor Damage Immunity, Boomerang Mastery+, Desert Super Enhancement, Cave Super Enhancement"
]],
    7035 => # ゴッドギャンブラー
      [[ "The ultimate gambler who has reached the realm of gods The SKL learned are highly reliant on luck with glory and ruin hanging by a thread It is possible to double up and increase experience points significantly but the risk is high. If you want to add a touch of luck to your battles this job is the one to choose",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Staff, Rod, Cards, Skill: Oracle, Passive: 4x Item Drop, Card Mastery+"
]],
    7036 => # 舞踏神
      [[ "The ultimate dancer who even wields the power of the galaxy Learns numerous powerful dances capable of destroying enemies with the Dance of the Galaxy Also learns various abilities to enhance the effects of dancing Basic abilities are not high so be cautious as they are fragile when exposed to enemy attacks",
  "",
  "",
  "",
  "",
],
[
  "Equip: Daggers, Rapiers, Whips, Fans, Skill: Fan, Dance, Passive: Fan Mastery+"
]],
    7037 => # 歌唱神
      [[ "The ultimate singer whose voice is said to reach even chaos The songs learned are particularly useful against chaotic beings Also has a variety of support SKL providing great protection to allies Extremely useful as a support role but weak in direct combat so be cautious",
  "",
  "",
  "",
  "",
],
[
  "Equip: Boomerangs, Harps, Skill: Sing, Passive: Harp Mastery+"
]],
    7038 => # コズミックアイドル
      [[ "The ultimate star who has raised their abilities to the level of the galaxy Their songs and dances reach into chaos bringing about immense destruction They can also learn support SKL that utilize the power of the galaxy Capable of both singing and dancing they are suitable as the pinnacle of support roles",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Whip, Harp, Fan, Skill: Fan, Dance, Sing, Passive: Normal Attack Temptation 30%, Fan & Harp Mastery+"
]],
    7039 => # QOBF
      [[ "A profession that has mastered pleasure abbreviated as Queen of Battle Fucker Boasts overwhelming pleasure specialization performance learning numerous powerful SKL Additionally they have high resistance to pleasure and are almost immune to pleasure attributes An attacker boasting unparalleled performance against enemies weak to pleasure",
  "",
  "",
  "",
  "",
  "",
],
[
  "Equip: Whip, Fist, Sex Toy, Skill: Whip, Unarmed, Sexcraft, Passive: Normal Attack Sensitive 10%, Normal Attack Ecstasy 10%, Normal Attack Temptation 10%, Normal Attack Incontinence 10%, Pleasure Resistance 25%, Sex Toy Mastery+"
]],
    7040 => # 禁忌科学者
      [[ "A forbidden magic scientist who has delved into the realm of taboos Their technology causes destructive phenomena by applying the power of the galaxy Additionally they can spread the effects of MP and SP conversion to the entire party Exerts powerful force as a magic attacker using SP",
  "",
  "",
  "",
  "",
],
[
  "Equip: Rod, Scalpel, Grimoire, Gun, Skill: Magi-Science, Alchemy, Grimoire Arts, Passive: Magic Mastery+"
]],
    7041 => # トリスメギストス
      [[ "The ultimate alchemist who has mastered alchemy The refined alchemical tools are extremely useful and can change the course of battle However be aware that the consumption of alchemical materials will increase significantly Additionally the characters stats are not particularly high with all except for magic being below the average of sealed jobs",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Staff, Rod, Grimoire, Skill: Magi-Science, Alchemy, Grimoire Arts, Passive: Automatic Alchemy Material Acquisition, Magic Mastery+"
]],
    7042 => # アカシックレコード
      [[ "The ultimate magi-librarian who has obtained forbidden power Step into the realm of chaos and unleash nano attribute attack magic Its power is higher than regular magic but be cautious of the high page consumption Various abilities suitable for using magic book SKL can also be learned",
  "",
  "",
  "",
  "",
],
[
  "Equip: Staff, Rod, Magic Book, Skill: Magi-Science, Alchemy, Grimoire Arts, Passive: Magic Mastery+"
]],
    7043 => # ゴッドマシーナリー
      [[ "Forbidden machinist capable of handling Makina born from chaos The destructive power of unknown Makina is extremely immense demonstrating overwhelming annihilation power However it cannot be used unless you have obtained that Makina High HP and DEF making them very valuable as an attacker",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Club, Gun, Skill: Makina, Passive: Gun Mastery+"
]],
    7044 => # 究極魔芸師
      [[ "The ultimate seeker who has mastered the three dark arts of necromancy spirit summoning and puppetry Learns the ultimate SKL of each dark art demonstrating overwhelming power Also learns many useful SKL such as magic and dexterity charge SKL Overall high stats capable of excelling in any situation",
  "",
  "",
  "",
  "",
],
[
  "Equip: Scythe, Staff, Rod, Whip, Scalpel, Grimoire, Gun, Skill: Scythe, Black Magic, Summoning, Makina, Medicine, Corpse, Artificial, Passive: Can equip magical armor, +Magic Mastery"
]],
    7045 => # 言霊神
      [[ "The ultimate wordsmith who has reached the realm of chaos Capable of using extremely powerful speech SKL such as increasing the number of actions Demonstrates excellent support capabilities with various speech SKL The stats other than Agility and Dexterity are low so caution is needed when handling",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Boomerang, Gun, Skill: Throwing, Talk, Passive: Boomerang Mastery+"
]],
    7046 => # 料理神
      [[ "Finally stepping into the realm of chaos the ultimate chef The dishes created by those hands can even exhibit galactic power Additionally it is possible to create dishes from nothing without any ingredients The abilities learned to enhance cooking are also useful providing high support effects",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Scythe, Kitchen Knife, Skill: Dagger, Cooking, Passive: Knife Mastery+"
]],
    7047 => # 禁医
      [[ "A doctor who has dabbled in forbidden territory The various medical SKL that can be learned are extremely useful Specializes in healing and support significantly enhancing the party Also learns attack SKL demonstrating versatile power",
  "",
  "",
  "",
  "",
],
[
  "Equip: Staff, Scalpel, Skill: Dagger, Medicine, Passive: Scalpel Mastery+"
]],
    7048 => # ゴッドメイド
      [[ "The ultimate supreme maid who has reached the divine realm Exhibits versatile power with pleasure attacks healing and support Each stat is above average capable of excelling in any situation",
  "",
  "",
  "",
  "",
],
[
  "Equip: Fan, Whip, Plate, Sex Toy, Skill: Whip, Service, Passive: Plate Mastery+"
]],
    7049 => # オールジョブラウンダー
      [[ "A seeker who has mastered countless professions and numerous job SKL Proficient in all jobs and able to use all job SKL Learns abilities to enhance various job SKL increasing their power Can also learn an ability to triple the experience gained from jobs",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Club, Scythe, Staff, Rod, Whip, Harp, Boomerang, Fan, Kitchen Knife, Abacus, Scalpel, Cards,　Plate,　Grimoire　Sex Toy Skill: Mercantile 　EX-Item　Oracle　Dance　Sing　Talk　Magic Science, Alchemy　Grimoire　Makina　Cooking　Medicine　Service　Sexcraft, Passive: Dual Wield"
]],
    7050 => # 覇王
      [[ "The supreme ruler standing at the pinnacle of all kings Possesses immense power overwhelming enemies with both physical and magical prowess Has mastered numerous combat-oriented abilities making combat capabilities extremely high Boasts versatile power making it a reliable job at any time",
  "",
  "",
  "",
],
[
  "Equip: Swords　Knight Swords　Great Swords　Rapiers　Magic Swords　Staffs　Rods　Grimoires, Skill: Sword 　White Magic　Black Magic　Time Magic　Holy　Ruling, Passive: Holy Technique Power +50%, Recover 20% HP every turn, Recover 4% MP every turn, 50% Magic Reflection, can equip heavy armor, Can equip magic armor, Sword & Magic Mastery +"
]],
    7051 => # 混沌の勇者
      [[ "Master of both Light and Darkness a forbidden hero turned chaos Can learn Holy attribute SKL Dark attribute SKL and even Ashura attribute SKL All abilities except Dexterity are extremely high demonstrating overwhelming combat power Possesses a variety of abilities suitable to be the pinnacle of frontline professions",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Sword, Knight Sword, Great Sword, Rapier, Spear, Heavy Spear, Axe, Club, Scythe, Boomerang, Skill: Dagger, Sword, Holy, Heroism, Passive: Holy Technique Power +50%, Recover 20% SP every turn, Sword Mastery+"
]],
    7052 => # サイコトリニティ
      [[ "Master of Psycho Power a forbidden sorcerer who has stepped into the realm of chaos Their psychokinesis creates nuclear flames bringing ruin to enemy groups Additionally their high magic and dexterity allow for the use of magic and pleasure SKL A versatile job that can overwhelm enemies with a variety of attacks",
  "",
  "",
  "",
  "",
],
[
  "Equip: Magic Sword, Rod, Sex Toy, Skill: Sword, Black Magic, Psychic, Sexcraft, Passive: Recover 6% MP Each Turn, Sword & Sex Toy Mastery+"
]],
    7053 => # ラストノーブル
      [[ "A forbidden Rapier user who has mastered their SKL to the extreme approaching the realm of chaos Their Rapier is imbued with the power of the galaxy mercilessly piercing even the toughest enemies They can perform a very high number of consecutive attacks and this number can be further increased with abilities ATK against bosses also increases making them a reliable high-speed attacker.",
  "",
  "",
  "",
  "",
  "",
],
[
  "Equip: Rapier, Spear. Skill: \\I[697]. Passive: 50% Physical Reflection, 40% Boss Special Attack, Rapier Mastery+"
]],
    7054 => # 禁忌妖術師
      [[ "A forbidden sorcerer who has mastered SKL to the point of taboo Basic abilities are high and various SKL learned can be used as sorcery Additionally abilities that enhance the effects of special SKL can be acquired If one can master sorcery they will demonstrate immense power",
  "",
  "",
  "",
  "",
],
[
  "Equip: Magic Sword, Fist, Scythe, Staff, Rod, Fan, Skill: Sorcery, Passive: Learning, Scythe Mastery+"
]],
    7055 => # シールドヒーロー
      [[ "A true hero who protects the party with a sturdy shield Equip shields in both hands protecting allies from various threats The SKL that can be learned are all SKL to protect allies If in the party they can greatly reduce the damage taken",
  "",
  "",
  "",
  "",
],
[
  "Equip: None, Skill: Throwing, Passive: Double Shield, Can Equip Heavy Armor, Super Endure, Super Appeal, Shield Mastery+"
]],
    7056 => # 超魔生物
      [[ "A warrior who has modified their own body achieving an ultimate physique Specializes solely in the use of monster SKL greatly enhancing their power Also reduces SP consumption when using them excelling in sustained combat However if they use weapons or magic they cannot demonstrate their true power.",
  "",
  "",
  "",
  "",
],
[
  "Equipped Weapon: Fangs, Skill: All Monster, Passive: Monster Technique Overbooster"
]],
    7057 => # 剣ヲ極メシ者
      [[ "A sealed job mastered by those who have mastered the sword. It is said that their sword can even cut through stars. Possess overwhelming stamina and ATK and learn numerous forbidden sword SKL. They also learn abilities that extremely reduce SP consumption allowing them to use powerful SKL repeatedly. There is no doubt that they wield formidable power as a frontline role.",
  "",
  "",
  "",
  "",
],
[
  "Equip: Daggers, Swords, Knight Swords, Great Swords, Rapiers, Magic Swords, Katanas, Skill: Dagger, Sword, Rapier, Katana, Black Magic, Taoism Arts, Magic Sword, Passive: Can Equip Heavy Armor, Sword/Katana High Mastery+, SP Consumption 1/4, Activate Higher Chaos Attributes with Magic Sword, Guard after Sword/Katana"
]],
    7058 => # 全テヲ穿ツ者
      [[ "A sealed job of one who pierces everything said to even penetrate the sun with a single strike Masters SKL of the Rapier and spear piercing enemies with astonishing speed Has a trait where the more consecutive hits the greater the power Also deals damage ignoring the opponents physical resistance",
  "",
  "",
  "",
  "",
],
[
  "Equip: Rapier, Spear, Heavy Spear, Skill: Rapier, Spear, Passive: Can Equip Heavy Armor, 50% Physical Reflection, Physical Resistance Penetration, Heat Up Combo, Spear/Rapier High Mastery+"
]],
    7059 => # 全テヲ壊ス者
      [[ "A forbidden job for those who destroy everything their strike is said to even annihilate galaxies. Mastering the SKL of axes staffs and Flails they destroy enemies with overwhelming super power. With high DEF they exhibit the greatest power in frontal combat. Not suitable for magic at all but the best attacker in physical combat.",
  "",
  "",
  "",
  "",
],
[
  "Equip: Great Sword, Axe, Club, Flail, Skill: Axe, Club, Flail, Passive: Super Endurance, Heavy Equipment Possible, SP Charge 3x, Chain  Super Enhancement, Power High Mastery+"
]],
    7060 => # 拳ヲ極メシ者
      [[ "A forbidden job for those who master fists their fists are said to reverse the heavens and earth. Always triggers critical hits and counters boasting ultimate martial strength. Additionally they can learn Unarmed with ultimate destructive power. With extraordinary ATK and agility they will demonstrate absolute annihilation power.",
  "",
  "",
  "",
  "",
],
[
  "Equip: Fist, Club, Skill: Unarmed, Passive: Perfect Counter, Perfect Magic Counter, Can equip Unarmed uniform, Fist High Mastery +, Counterattack damage enhanced 4 levels, activates Rush Time upon evasion"
]],
    7061 => # 全テヲ護ル者
      [[ "A sealed job for those who protect everything said to even withstand the impact of a meteor strike Learns multiple powerful defensive SKL to protect the entire party from enemy attacks Also learns powerful holy SKL and shield throwing SKL allowing for offensive maneuvers Has overwhelming HP and DEF resulting in extremely high survival rate",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Fist, Staff, Wand, Gi, Heavy Armor. Skill: Throwing, Unarmed, White Magic, Holy, Passive: Holy Technique Power +50%, Halve all damage, Double Shield, Super Endure, Super Appeal, Fist/Boomerang/Shield High Mastery+"
]],
    7062 => # 千ノ武具ヲ極メシ者
      [[ "A forbidden job for those who have mastered a thousand weapons capable of using all manner of arms The barrage SKL and abilities learned boast destructive power Additionally they can learn an ability to consecutively unleash martial SKL Their stats except for magic are extremely high demonstrating unparalleled power on the front lines",
  "",
  "",
  "",
  "",
],
[
  "Equip: All Weapons, Skill: Dagger, Sword, Rapier, Katana, Spear, Axe, Club, Scythe, Bow, Whip, Throwing, Flail, Fan, Gun, Multi-Weapon, Passive: Triple Wield, Enhanced Triple Wield, Master Barrage, Weapon  Globalization, Super Heat Up Combo, High Mastery of All Normal Weapons+"
]],
    7063 => # 全テヲ識ル者
      [[ "A forbidden job for those who know everything sealed due to their extraordinary power With immense magic power they are said to control the workings of all things Learn the ultimate magic that existed in ancient times and control everything in this world Additionally numerous abilities that support magic use are extremely powerful",
  "",
  "",
  "",
  "",
],
[
  "Equip: Magic Sword, Scythe, Staff, Rod, Fan, Magic Book, Skill: White Magic, Black Magic, Time Magic, Summoning, Holy, Dark, Taoism, Passive: Maximize Holy and Dark  Power, Magic Globalization, MP Consumption 1/4, Witch Time, Ignore Time Stop, Equipable Magic Armor, Magic High Mastery+"
]],
    7080 => # 全てを癒す者
      [[ "A forbidden job that provides ultimate healing worshipped as a savior Master healing SKL equivalent to divine SKL healing even reserve allies Besides healing SKL support allies with numerous support SKL Defense performance is not low ensuring high survivability even in fierce battles",
  "",
  "",
  "",
],
[
  "Equip: Staff, Rod, Scalpel, Grimoire, Skill: Unarmed, White Magic, Holy, Medicine, Passive: Holy Technique Power +50%, MP Cost 1/2, Super Endure, Activate 2 Deflects at the Start of Battle, Automatically Revive Once Upon Defeat"
]],
    7064 => # 全テヲ撃チ抜ク者
      [[ "A forbidden job for those who shoot through everything said to even shoot through stars Masters bows and guns using sniping SKL with overwhelming dexterity Greatly enhances the effects of various special attacks efficiently eliminating targeted monsters Weak in defense but excels in extermination power as an attacker",
  "",
  "",
  "",
  "",
],
[
  "Equip: Bow and Arrow, Gun, Skill: Bow, Gun Passive: Greatly Enhanced Racial Special Attack, Greatly Enhanced Status Ailment Special Attack, Bow and Gun High Mastery+"
]],
    7065 => # 音ヨリモ速キ者
      [[ "A forbidden class for those faster than sound so fast that they are impossible to see Can use powerful dagger SKL and ninjutsu to overpower enemies with overwhelming speed Exceptionally high evasion rate able to dodge most attacks with high probability Can even evade chaos attributes significantly reducing damage taken as a result",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Ninja Sword, Boomerang, Sex Toys, Gi Skill: Dagger, Throwing, Thievery, Ninjutsu, Sexcraft, Passive: 5x Steal Rate, Immune to Surprise Attacks, Increased Preemptive Attack, Dual Wield, Enhanced Dual Wield, Dagger/Ninja Sword/Boomerang High Mastery+, Activates Sophisticate upon Evasion"
]],
    7066 => # 極マリシ偶像
      [[ "A forbidden job for the ultimate idol their existence has become symbolic Masters singing and dancing to the extreme capable of adding galactic energy The effects of support songs and dances are also high greatly enhancing the entire party Their own stats are not high but they will show outstanding performance as a support role",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Whip, Harp, Fan, Skill: Fan, Dance, Sing, Passive: Normal Attack Temptation 50%, Fan/Harp High Mastery+, Hustle Dance Activation on Counter"
]],
    7067 => # 快楽ヲ極メシ者
      [[ "A forbidden job for those who have mastered pleasure capable of bringing anyone and anything to climax regardless of age or gender In addition to the highest level of pleasure SKL can also learn SKL belonging to the Psychic category Naturally Dexterity is at the highest level excelling in pleasure attacks Also they are completely immune to pleasure making their defense perfect",
  "",
  "",
  "",
  "",
],
[
  "Equip: Whip, Fist, Sex Toy, Skill: Whip, Unarmed, Sexcraft, Psychic, Passive: Normal Attack Sensitive 15%, Normal Attack Ecstasy 15%, Normal Attack Temptation 15%, Normal Attack Incontinence 15%, Immune to Pleasure and Nightmare Attributes, Immune to Climax and Pleasure Status Ailments, Whip/Fan/Sex Toy High Mastery+"
]],
    7068 => # 真理ノ探究者
      [[ "A forbidden job for seekers of truth said to have mastered the pursuit A being proficient in Magi-Science Alchemy handling Makina and magical arts Learns various SKL with the highest level of power possessing an extremely wide array of offensive options Boasts an unparalleled performance as an attacker with numerous chaos attributes at their disposal",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Scythe, Club, Staff, Rod, Whip, Scalpel, Grimoire, Gun, Skill: Scythe, Black Magic, Summoning, Magi-Science, Alchemy, Grimoire Arts, Makina, Medicine, Corpse, Artificial, Passive: Stockpile Acquisition, Can Equip Magic Armor, Magic/Gun High Mastery+, Activates Sophisticate on Counter"
]],
    7069 => # 万職ヲ極メシ仕事人
      [[ "A forbidden job for the master of all professions learning numerous SKL Said to disrupt the laws of heaven and earth as well as the employment situation in the mundane world Learns many forbidden abilities that greatly enhance job SKL The ability to activate job SKL consecutively is extremely powerful.",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Rapier, Club, Scythe, Staff, Rod, Whip, Harp, Boomerang, Fan, Kitchen Knife, Abacus, Scalpel, Cards, Plates, Grimoires, Guns, Sex Toys, Skill: Mercantile 　EX-Item　Oracle　Dance　Sing　Talk　Magic Science, Alchemy　Grimoire　Makina　Cooking　Medicine　Service　Erotic, Passive: Medicine Lore III, Triple Wield, Enhanced Triple Wield, Job  Globalization, 5x Gold Acquisition and Drop Rate, Job Weapon High Mastery+"
]],
    7070 => # 英雄王
      [[ "A forbidden hero king who has mastered numerous martial SKL and become a legend itself. Boasts martial strength that disrupts the heavens and intimidates even the gods. Can learn ultimate sword SKL and extraordinary abilities. Strong against formidable enemies demonstrating strength that will go down in history.",
  "",
  "",
  "",
],
[
  "Equip: Swords　Knight Swords　Great Swords　Rapiers　Magic Swords　Staffs　Rods　Grimoires, Skill: Sword, White Magic, Black Magic, Time Magic, Holy, Ruling, Heroism, Passive: Holy Technique Power +50%, Recover 20% HP every turn, Recover 20% SP Every Turn, Recover 4% MP Every Turn, 50% Boss Special Attack, Reduced damage from bosses, can equip heavy armor and magic armor, Halved SP consumption, Sword & Magic High Mastery+"
]],
    7073 => # 破滅事象
      [[ "The ultimate warrior who was forbidden for their destructive power in another world Greatly enhances the power of monster SKL annihilating everything The abilities that can be learned are enough to distort the laws of the world Cannot use weapons or magic but possesses catastrophic power",
  "",
  "",
  "",
  "",
],
[
  "Equipped Weapon: Fangs, Skill: All Monster, Passive: Monster Technique Max Booster"
]],
    7071 => # ジャッジメント
      [[ "A judge who descended to earth to judge the world itself Their radiance instantly eradicates all evil Can learn the ultimate holy SKL and abilities beyond human understanding Their stats are extremely high boasting power that surpasses even the gods",
  "",
  "",
  "",
],
[
  "Equip: Sword, Knight Sword, Magic Fist, Staff, Rod, Grimoire, Skill: Sword, Black Magic, White Magic, Time Magic, Holy, Heroism, Passive: Holy Technique Power +100%, All attacks gain Eternal effect, Eternal Absorption, Ignores Time Stop, All Weapon Mastery+"
]],
    7072 => # ワールドブレイカー
      [[ "The destroyer of all things who appeared to destroy the world Capable of annihilating dimensions themselves returning them to nothingness Can learn the ultimate dark SKL and abilities beyond human understanding Their stats are extremely high boasting power that surpasses even the gods",
  "",
  "",
  "",
  "",
],
[
  "Equip: Sword, Knight Sword, Magic Sword, Gun, Skill: Sword, Dark, Heroism, Passive: Dark Technique Power +100%, All attacks gain Apocalypse effect, Apocalypse Absorption, Ignores Time Stop, All Weapon Mastery+"
]],
    7074 => # 虚職
      [[ "An advanced class that expands on being jobless a non-existent job Job level increases but no SKL are learned Stats are not high and training itself becomes a hardship However mastering this allows progression to the highest jobless class",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Skill: None, Passive: None"
]],
    7075 => # 空職
      [[ "The highest non-existent class that expands on being jobless Job level increases but no SKL are learned Their stats are average but they cant be said to be particularly strong However mastering this allows progression to the sealed job of being jobless",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Skill: None, Passive: None"
]],
    7076 => # 零職
      [[ "A non-existent sealed job that expands on being jobless Job level increases but no SKL are learned Stats are higher but with no abilities making it difficult to utilize However mastering this will lead to...",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Skill: None, Passive: None"
]],
    7077 => # 職無キ者
      [[ "A non-existent forbidden job that expands on being jobless Stats are higher but with no abilities making it difficult to utilize However the abilities that can be learned are extremely powerful Accept the opportunity to learn abilities and endure the hardship",
  "",
  "",
  "",
  "",
],
[
  "Equip: Dagger, Skill: None, Passive: None"
]],
    7078 => # もんむす・くえすと！
      [[ "The pinnacle and ultimate achievement of monster girls Truly thank you for your hard work",
  "",
  "",
  "",
  "",
],
[
  "Equip: All, Skill: All, Passive: None"
]],

    151 => # 人間 / Human
      [[
        "A pure, commonplace human. Fairly talkative, armor that can be equipped depends on the individual. Humans learn many abilities related to experience point acquisition.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: None",
        "Skills: Talk",
        "Passive: None",
        "",
      ]],
    152 => # 魔人 / Demonoid
      [[
        "A descendant of man who has awakened to their dark powers. Can manipulate time and learns exclusive scythe skills. Extremely high stats allow them to excel in all situations.",
        "",
        "",
        "",
      ],
      [
        "Equip: Sword,Scythe,Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,",
        "   Hat,Helmet,Heavy Helmet,Magic Hat,Fancy Cap,Buckler,Shield,",
        "   Heavy Shield",
        "Skills: Sword,Scythe,Unarmed,Black Magic,Time Magic,",
        "　　　Dark,Demon Arts",
        "Passive: Sword/Katana/Fist/Scythe/Magic Mastery, Contract of Darkness",
        "",
      ]],
    153 => # 魔神 / Archfiend
      [[
        "A Demonoid manifesting the bloodline of a fallen angel. Possesses power rivaling that of a god. Strong dark and time magic allows them to control time and space. Specializes in the Carnage attribute and learns several boosting and resistance abilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sword,Scythe,Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,",
        "   Hat,Helmet,Heavy Helmet,Magic Hat,Fancy Cap,Buckler,Shield,",
        "   Heavy Shield",
        "Skills: Scythe,Time Magic,Holy,Dark",
        "Passive: Null HP Cost, Sword/Scythe/Magic Mastery+",
        "",
      ]],
    154 => # 超魔神
      [[ "A mighty demon god who has further enhanced their power Can use dark attributes without HP consumption and also use time-stopping SKL Their stats are extremely high and their attribute resistances are nearly invincible A being beyond human understanding capable of excelling in any situation",
  "",
  "",
  "",
],
[
  "Equip: All Armor A, Skill: Sword, Scythe, Unarmed, Time Magic, Holy, Dark, Passive: Greatly Enhance Holy and Dark Techniques, Can Equip Scythe and Heavy Armor, Ruler of Darkness, Immune to Physical and Pleasure, Ignore Time Stop, Sword/Scythe/Magic Mastery+"
]],
    7412 => # 混沌の魔神
      [[ "The ultimate demon god who has mastered even the power of chaos Transcends even the realm of gods coming extremely close to chaos itself Possesses tremendous stats and resistances making their power both versatile and ultimate The abilities that can be learned are also extremely powerful",
  "",
  "",
  "",
  "",
],
[
  "Equip: All Armor SSS, Skill: Sword, Scythe, Unarmed, Time Magic, Holy, Dark, Chaos, Passive: Maximize Holy and Dark Technique Power, Can Equip Scythe and Heavy Armor, Ruler of Darkness, Physical and Pleasure Reflection, Ignore Time Stop, Sword/Scythe/Magic Mastery+"
]],
    155 => # ワームサマナー / Worm Summoner
      [[
        "A human mage who has integrated a Homunculus into their body at a cellular level and is no longer human. Attacks with tentacle skills and HP draining attacks. Can also automatically regenerate MP during battle.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Dress,Skimpy,Hat,Magic Hat",
        "   Buckler",
        "Skills: Black Magic,Summoning,Slime,Tentacle",
        "Passive: Mag Eva +20%,MP Regen +1%",
        "",
      ]],
    156 => # マスターホムンクルス / Master Homunculus
      [[
        "A grotesque human being whose cells were mixed with those of a homunculus, increasing their power significantly. The Master Homunculus possesses tentacles that are used to prey on its enemies by absorbing their HP and MP, even devouring them whole.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Dress,Skimpy,Hat,Magic Hat",
        "   Buckler",
        "Skills: Black Magic,Summoning,Slime,Tentacle",
        "Passive: Mag Eva +20%,MP Regen +2%",
        "",
      ]],
    157 => # ワームエンプレス
      [[ "The empress of tentacle summoners who commands the ultimate worm Due to its immense and abominable power it was designated as a sealed species Countless tentacles can squeeze and absorb the essence of any living being Also learns a chain ability that activates summoning SKL from tentacle SKL",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes B, Breastplate C, Robe A, Dress B, Skimpy B, Hat B, Magic Hat A, Buckler C, Skill: Black Magic, Summoning, Tentacle, Passive: Recover 4% MP Every Turn, Halved MP Consumption When Near Death"
]],
    7413 => # 万魔の宿主
      [[ "A forbidden being that harbors the cells of all monsters within its body Designated as a forbidden species due to being influenced by a dimensional invader Manipulates worms with magic and can also activate dimensional-scale magic High resistance to pleasure and attributes able to fully utilize immense magical power",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Breastplate S, Robe SSS, Dress SS, Skimpy SS, Hat SS, Magic Hat SSS, Buckler S, Skill: Black Magic, Summoning, Tentacle, Passive: Recover 8% MP Every Turn, Zero MP Consumption When Near Death"
]],
    158 => # 妖魔 / Yoma
      [[
        "The monster race with the highest magical power and intelligence. Yoma are strong and utilize magnificent Rapier skills. Their magical prowess is often put to use in fire magic, roasting their enemies alive. They wear heavy armor and have no particular weaknesses.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Rapier,Black Magic,Dark,Demon Arts",
        "Passive: Rapier Booster 20%",
        "",
      ]],
    159 => # 上級妖魔 / High Yoma
      [[
        "A race with a prestigious pedigree among the Yoma. Proud of their high combat efficiency with rapiers and fire magic. Learns more effective magic eyes and numerous other attacks. An all-purpose race that excels in any combat situation.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Rapier,Black Magic,Dark,Demon Arts",
        "Passive: Rapier Booster 20%",
        "",
      ]],
    160 => # 妖魔貴族 / Noble Yoma
      [[
        "The highest rank of Yoma, boasting a noble lineage. They hold tremendous magic power capable of reducing any foe to ash. Their ability with a rapier is superb, having acquired the Yoma secrets of the weapon. Extraordinary stats.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Rapier,Black Magic,Dark,Demon Arts",
        "Passive: Rapier Booster 20%",
        "",
      ]],
	161 => # 聖魔 / Holy Yoma
      [[
        "An unusual Yoma who acquired holy power through mutation. Learns Holy attacks in addition to White Magic. Can use magic eyes to heal allies. Attack power is less than a yoma, but their magic is extremely strong.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Robe,Dress,Skimpy,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Rapier,White Magic,Black Magic,Holy,Dark,Demon Arts",
        "Passive: Rapier Booster 20%",
        "",
      ]],
    162 => # 神魔 / Divine Yoma
      [[
        "A sacred Yoma worshiped as a god, wielding powerful Lightning magic and smiting enemies with Holy might. The Divine Yoma's eyes possess powerful magic that can revive the dead and heal severe wounds. With excellent attack and recovery skills, the Divine Yoma is a dependable race.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Robe,Dress,Skimpy,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Rapier,White Magic,Black Magic,Holy,Dark,Demon Arts",
        "Passive: Rapier Booster 20%",
        "",
      ]],
    163 => # 半獣妖魔 / Bestial Yoma
      [[
        "A subspecies of Yoma with the lower half of a beast. The bestial parts such as claws and fangs can shred foes, while the Yoma parts provide strong magic, especially ice. A reliable species in all aspects of combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Breastplate,Armor,Robe,Dress,Skimpy,Hat",
        "   Helmet,Fancy Cap,Buckler,Shield",
        "Skills: Rapier,Black Magic,Dark,Demon Arts,Beast",
        "Passive: Crit +15%,Eva +20%,Rumble,Rapier Booster 20%",
        "",
      ]],
    164 => # 邪獣妖魔 / Feral Yoma
      [[
        "A high class Yoma whose body has awoken to the true power of Beast monsters, harnessing the destructive power within them to unleash devastating physical attacks. Combined with mastery over Ice magic, this race is perfectly suited for offensively-oriented roles.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Breastplate,Armor,Robe,Dress,Skimpy",
        "   Hat,Helmet,Fancy Cap,Buckler,Shield",
        "Skills: Rapier,Black Magic,Dark,Demon Arts,Beast",
        "Passive: Crit +15%,Eva +20%,War Rumble",
        "   Rapier Booster 20%",
      ]],
    165 => # 古神 / Ancient Deity
      [[
        "Harboring powerful genes from a bygone age, the Ancient Deity wields ancient powers from both Holy and Dark skills alike. Because of their nature as a monster, the Ancient Deity can use a variety of pleasure attacks. With a variety of powerful physical and pleasure attacks, the Ancient Deity's power is unparalleled.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Breastplate,Armor,Robe,Dress,Skimpy",
        "   Hat,Helmet,Fancy Cap,Buckler,Shield",
        "Skills: Rapier,White Magic,Black Magic,Holy,Dark,Demon Arts",
        "   Beast",
        "Passive: Eva +20%,Rapier Booster 30%",
      ]],
    166 => # 魔王
      [[ "The emperor reigning at the pinnacle of all monsters Contains the genes of various monsters boasting overwhelming power Due to their lineage can use dark attribute SKL at half HP cost Learns extremely powerful SKL including ultimate fire and dark SKL",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes B, Breastplate B, Armor A, Heavy Armor A, Robe A, Dress A, Skimpy A, Hat B, Helmet A, Heavy Helmet A, Magic Hat A, Fancy Cap A, Buckler B, Shield B, Heavy Shield A, Skill: Rapier, White Magic, Black Magic, Dark, Demon Arts, Beast, Passive: Increase Rapier and Fang Power 30%, Greatly Enhance Dark Techniques, Half HP Consumption for Dark Attribute, Can Equip Fangs"
]],
    7414 => # 大魔王
      [[ "The ultimate demon lord reigning over the world of darkness Their power is said to rival that of gods and their very existence is forbidden Learns ultimate fire magic Rapier SKL and also the secret art to enshroud the world in darkness Boasts top-class ATK and magic capable of destroying any enemy",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Breastplate SS, Armor SSS, Heavy Armor SSS, Robe SSS, Dress SSS, Skimpy SSS, Hat SS, Helmet SSS, Heavy Helmet SSS, Magic Hat SSS, Fancy Cap SSS, Buckler SS, Shield SS, Heavy Shield SSS, Skill: Rapier, White Magic, Black Magic, Dark, Demon Arts, Beast, Passive: Increase Rapier and Fang Power 30%, Maximize Dark Techniques Power 75%, Dark Attribute  HP Consumption 1/4, Can Equip Fangs"
]],
    167 => # 亜人 / Demi-Human
      [[
        "Monsters that resemble humans. Aside from HP and magic, their stats are mostly identical to humans. Draining hair, frisky tongue, and oriental ice magic sets them apart. A similar build to humans allows for similar equipment.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Dress,Skimpy,Hat,Helmet",
        "   Buckler,Shield",
        "Skills: Scythe,Taoism,Demon Arts",
        "Passive: Scythe Booster 20%",
        "",
      ]],
    168 => # 妖怪 / Youkai
      [[
        "Also called Mononoke, Youkai are Demi-Humans with stronger magic. They mostly live to the east, coexisting with humans. Other than using their hair and tongues as weapons, they can learn ice magic. A useful species with balanced physical and magical capabilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Dress,Skimpy,Hat,Helmet",
        "   Buckler,Shield",
        "Skills: Scythe,Taoism,Demon Arts",
        "Passive: SP Cost 75%,Scythe Booster 20%",
        "",
      ]],
    169 => # 妖神 / Elder Youkai
      [[
        "A higher-ranked Youkai who is revered as a God in the Eastern Lands, wielding the power to freeze enemies and everything around them. They are a mighty race, using their hair and tongue skill to bring mind-numbing pleasure and raw physical power to inflict excruciating pain.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Dress,Skimpy,Hat,Helmet",
        "   Buckler,Shield",
        "Skills: Scythe,Taoism,Demon Arts",
        "Passive: SP Cost 50%,Scythe Booster 20%",
        "",
      ]],
    170 => # 妖鬼 / Oni
      [[
        "A subspecies of Youkai known for their strength. Experts at using clubs and crushing foes with strong skills. They learn ice attacks and full-body techniques which never leave them wanting for physical skills. High attack power and defense, but comparatively weak to magic and pleasure.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Heavy Armor,Dress,Skimpy",
        "   Hat,Helmet,Heavy Helmet,Buckler,Shield,Heavy Shield",
        "Skills: Axe,Club,Demon Arts",
        "Passive: Crit +15%,Battle Start SP 75%",
      ]],
    171 => # 鬼神 / Kishin
      [[
        "A high-ranking Oni revered as a god for their strength with a club, smashing everything in their path. Despite their inferior magic power, the Kishin is a dependable physical fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Heavy Armor,Dress,Skimpy",
        "   Hat,Helmet,Heavy Helmet,Buckler,Shield,Heavy Shield",
        "Skills: Axe,Club,Demon Arts",
        "Passive: Crit +15%,Battle Start SP 100%",
        "",
      ]],
    172 => # 夜叉 / Yasha
      [[
        "A Youkai that possesses multiple arms, each wielding a weapon to deliver unending slashes. Despite their lackluster defense, a Yasha can learn mighty sword skills and learn to attack twice for overwhelming power.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Dress,Skimpy,Hat,Helmet",
        "Skills: Katana,Multiweapon,Demon Arts",
        "Passive: Eva +10%,Dual Wield",
        "",
      ]],
    173 => # 阿修羅 / Ashura
      [[
        "A species of Kishin wielding countless blades with their multiple arms to mercilessly annihilate their enemies. The Ashura is able to learn powerful katana, multi-weapon and pleasure skills, as well as the ability to strike three times in a row.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Dress,Skimpy,Hat,Helmet",
        "Skills: Katana,Multiweapon,Demon Arts",
        "Passive: Eva +10%,Dual Wield",
        "",
      ]],
    174 => # 妖怪王
      [[ "A great youkai said to stand at the pinnacle of all demi-humans and youkai Sealed by the gods due to disrupting the balance of the world Masters the use of clubs and katanas beyond that of an expert learning extremely powerful attack SKL While their defense has weaknesses they demonstrate overwhelming power when attacking",
  "",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes A, Gi A, Breastplate B, Armor B, Dress C, Skimpy C, Hat A, Helmet B, Buckler B, Shield B, Skill: Katana, Scythe, Axe, Club, Taoism, Demon Arts, Passive: Increase Scythe Power 30%, Start Battle with 120% SP, SP Consumption 1/2, Critical Damage +50%"
]],
    7415 => # マガツオオミカミ
      [[ "The ultimate artificial demi-human created as a weapon by the Goddess Powered by the force of the underworld it destroyed worlds in another dimension Carries various divine artifacts in its multiple arms relentlessly engaging in destruction and slaughter SP consumption is also very low boasting overwhelming offensive capabilities",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Gi SSS, Breastplate SS, Armor SS, Dress S, Skimpy S, Hat SSS, Helmet SS, Buckler SS, Shield SS, Skill: Katana, Scythe, Axe, Club, Taoism, Demon Arts, Passive: Increase Scythe Power 30%, Start Battle with 150% SP, SP Consumption 1/4, Critical Damage +100%, Triple Wield, Enhanced Triple Wield"
]],
    175 => # インプ / Imp
      [[
        "Small demons who subsist on human semen; not quite skilled enough yet to be called succubi. Imps use pleasure attacks, drowning their enemies in bliss. They specialize in Wind techniques, but are otherwise poor fighters.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sex Toy,Clothes,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Black Magic,Sexcraft,Demon Arts,Nature",
        "Passive: Eva +10%,Horny/Trance Strike +5%",
        "",
      ]],
	176 => # サキュバス / Succubus
      [[
        "Imps who become proficient at sexual skills become full-fledged succubi capable of taking away their foe's will to fight through pleasure. They can also act as mages with their high magic power, but weak attack and defense make them poor in direct combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sex Toy,Clothes,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Black Magic,Sexcraft,Demon Arts,Nature",
        "Passive: Eva +10%,Horny/Trance/Seduction Strike +5%",
        "",
      ]],
    177 => # エルダーサキュバス / Elder Succubus
      [[
        "A high-ranking Succubus boasting superior pleasure skills, using them to squeeze everything from men and women alike. An Elder Succubus can learn powerful wind magic and mind-numbing pleasure skills, with one such skill capable of sending sleeping foes to an eternal slumber.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sex Toy,Clothes,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Black Magic,Sexcraft,Demon Arts,Nature",
        "Passive: Eva +10%,Horny/Trance/Seduction Strike +5%",
        "   Incontinence Strike +5%",
      ]],
    178 => # モンクサキュバス / Succubus Monk
      [[
        "A rare Succubus who has devoted her body and life to fighting, gaining high offensive power. Despite being a Succubus, she can throw powerful punches and whip out sharp slaps as well as she can milk enemies dry.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sex Toy,Clothes,Gi,Robe,Dress,Skimpy,Hat,Fancy Cap",
        "Skills: Unarmed,Sexcraft,Demon Arts,Nature",
        "Passive: Crit +15%,Eva +20%,Horny/Trance Strike +5%",
        "",
      ]],
    179 => # 淫闘サキュバス / Lewdfighter Succubus
      [[
        "A Succubus fighter who uses her body to overwhelm enemies with ancient combat skills and obscene pleasure attacks. The Lewdfighter Succubus can develop sexual defenses for themselves and master powerful pleasure skills to make enemies incontinent.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sex Toy,Clothes,Gi,Robe,Dress,Skimpy,Hat,Fancy Cap",
        "Skills: Unarmed,Sexcraft,Demon Arts,Nature",
        "Passive: Crit +15%,Eva +20%,Horny/Trance Strike +10%",
        "",
      ]],
    180 => # ウィッチサキュバス / Succubus Witch
      [[
        "A talented Succubus mage who has mastered lewd sorcery, in addition to powerful Wind and Black Magic spells. She can also learn to use her Demon Eyes to inflict pleasure status ailments, although she has lackluster defense, like other mages.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sex Toy,Clothes,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "Skills: Black Magic,Summoning,Sexcraft,Demon Arts,Nature",
        "Passive: Mag Eva +10%,Horny/Trance Strike +5%",
        "",
      ]],
    181 => # アークサキュバス / Arc Succubus
      [[
        "An archmage amongst Succubus Witches who has attained the apex of magic spells and rare pleasure skills. The Arc Succubus can learn more Black Magic spells, as well as summon wild tentacles to bring agonizing pleasure to enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sex Toy,Clothes,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "Skills: Black Magic,Summoning,Sexcraft,Demon Arts,Nature",
        "Passive: Mag Eva +10%,Horny/Trance Strike +10%",
        "",
      ]],
    182 => # クイーンサキュバス / Queen Succubus
      [[
        "The apex of all succubi, able to effortlessly ascend anyone to heaven with pleasures from all corners of the world. Perfectly balanced, her body is as beautiful as is powerful, unleashing devastating Wind magic and Martial Arts techniques.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Sex Toy,Clothes,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Unarmed,Black Magic,Summoning,Sexcraft,Demon Arts,Nature",
        "Passive: Eva +20%,Mag Eva +10%,Horny/Trance Strike +10%",
        "   Seduction/Incontinence Strike +10%",
      ]],
    183 => # リリスナイトメア
      [[ "A destructive succubus said to be closest to the primordial great succubus Despised by the goddess during the Great Monster Wars and designated as a sealed species The dust storm feared even by the goddess boasts destructive power that connects to chaos As a succubus their learned SKL are powerful boasting overwhelming agility and dexterity",
  "",
  "",
  "",
  "",
],
[
  "Equip:Clothes B, Unarmed Wear A, Robe B, Dress A, Light Clothing A, Headgear B, Magic Hat B, High-Class Hat A, Buckler A, Skill: Unarmed, Black Magic, Summoning, Sexcraft, Demon Arts, Nature Passive: Can equip sex tools, Normal Attack Sensitivity, Ecstasy, Seduction +20%, Incontinence +20%, Wind Resistance Penetration"
]],
    7416 => # バビロンの大淫婦
      [[ "The greatest and worst great succubus whose name remains only in ancient legends Said to corrupt all men with pleasure and lead them to ruin Can learn numerous Sexcraft SKL including powerful sexcraft Boasts unparalleled dexterity magic and agility demonstrating unmatched strength",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SSS, Robe SS, Dress SSS, Skimpy SSS, Hat SS, Magic Hat SS, Fancy Cap SSS, Buckler SSS, Skill: Unarmed, Black Magic, Summoning, Sexcraft, Demon Arts, Nature, Passive: Can equip sex tools, Normal Attack Sensitive +30%, Normal Attack Ecstasy +30%, Normal Attack Seduction +30%, Normal Attack Incontinence +30%, Penetrate Pleasure and Wind Resistance, All  power depends on dexterity"
]],
    184 => # ヴァンパイア / Vampire
      [[
        "Nocturnal monster that feeds on blood. Boasting strong bodies and even stronger magic, they can absorb HP and more via bloodsucking. Daggers are at their deadliest in their hands.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Armor,Heavy Armor,Robe,Dress,Hat,Helmet",
        "   Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Black Magic,Dark,Demon Arts",
        "Passive: Dagger Booster 20%",
        "",
      ]],
    185 => # ノスフェラトゥ / Nosferatu
      [[
        "A vampire that has fed on a large amount of blood, gaining great power. Learns powerful Dagger skills, and can feed on blood to drain not only life, but mana as well. If used well, they can fight on their own with no need for healing from allies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Armor,Heavy Armor,Robe,Dress,Hat,Helmet",
        "   Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Black Magic,Dark,Demon Arts",
        "Passive: Dagger Booster 20%",
        "",
      ]],
    186 => # 夜の帝王 / Night Emperor
      [[
        "A high ranking member of the Vampire aristocracy who have mastered the use of daggers and learn powerful Lightning techniques. They are able to drain life, mana and stamina when feeding on blood and their exceptional combat strength makes them reliable allies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Armor,Heavy Armor,Robe,Dress,Hat,Helmet",
        "   Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Black Magic,Dark,Demon Arts",
        "Passive: Dagger Booster 20%",
      ]],
    187 => # マージヴァンパイア / Vampire Magus
      [[
        "A Vampire mage with high magical potential who is proficient in a wide variety of area-of-effect elemental spells. They are also able to inflict status ailments on their enemies with their demon eyes and their defenses are surprisingly high for magic users, making them dependable allies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Armor,Robe,Dress,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Dagger,Black Magic,Summoning,Dark,Demon Arts",
        "Passive: None",
        "",
      ]],
    188 => # アークヴァンパイア / Arc Vampire
      [[
        "A Vampire archmage with extreme magical powers, possessing Black Magic capable of destroying every enemy at once. The Arc Vampire also possesses powerful Demon Arts able to inflict instant death on groups of enemies as well as high stats, making them an immensely powerful spellcaster.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Armor,Robe,Dress,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Dagger,Black Magic,Summoning,Dark,Demon Arts",
        "Passive: None",
        "",
      ]],
    189 => # シノビヴァンパイア / Vampire Shinobi
      [[
        "A Vampire who has trained in the ways of the Shinobi, boasting unrivaled physical strength and magical power. They can infuse preexisting ninjutsu with their demonic magic, creating brand new techniques. Their attack power is worthy of a Ninja, but their defense is no different from a mage.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Robe,Dress,Hat,Helmet,Fancy Cap",
        "Skills: Dagger,Dark,Ninjutsu,Demon Arts",
        "Passive: Eva +20%,Dual Wield",
        "",
      ]],
    190 => # クノイチナイトメア / Nightmare Kunoichi
      [[
        "A Vampire Shinobi who has pushed themselves beyond their limits, allowing them to overwhelm foes with physical and magical attacks. The Vampire Kunoichi learns many skills beyond the capabilities of average ninjas, giving them unparalleled offensive power.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Robe,Dress,Hat,Helmet,Fancy Cap",
        "Skills: Dagger,Dark,Ninjutsu,Demon Arts",
        "Passive: Eva +20%,Dual Wield",
        "",
      ]],
    192 => # クイーンヴァンパイア / Queen Vampire
      [[
        "A Vampire with royal blood who rules over her kind, rumored to live in a castle with hundreds of maids at her service. With complete mastery over Dagger skills and magic to bend the laws of nature, this vampire is the undisputed queen of the night.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Gi,Armor,Heavy Armor,Robe,Dress,Hat,Helmet",
        "   Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Ninjutsu,Black Magic,Summoning,Dark,Demon Arts",
        "Passive: Eva +20%,Dagger Booster 20%",
        "",
      ]],
    193 => # ドラキュリーナ
      [[ "A legendary vampire said to have rampaged during the Great Monster Wars Their lightning connects to chaos designated as a sealed species by the goddess Like similar types they have difficulties with defense and resistance but their offensive capabilities are overwhelming Excels in daggers and lightning attributes extremely proficient in both physical and magical combat",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes C, Gi C, Armor B, Heavy Armor B, Robe A, Dress A, Hat C, Helmet B, Heavy Helmet B, Fancy Cap A, Buckler B, Shield B, Heavy Shield B, Skill: Dagger, Ninjutsu, Black Magic, Summoning, Dark, Demon Arts, Passive: Increase Dagger Power 30%, Greatly Enhance Dark Techniques, Pierce Lightning Resistance, Can Equip Fangs, Fang Mastery+"
]],
    7417 => # 神祖
      [[ "The ultimate vampire who is the ancestor of all vampires It is said that their immense magic power can cover the world in night In addition to powerful magic SKL learns the ultimate secret art of dagger SKL Also learns powerful defensive SKL capable of compensating for resistance gaps",
  "",
  "",
  "",
],
[
  "Equip: Clothes S, Gi S, Armor SS, Heavy Armor SS, Robe SSS, Dress SSS, Hat S, Helmet SS, Heavy Helmet SS, Fancy Cap SSS, Buckler SS, Shield SS, Heavy Shield SS, Skill: Dagger, Ninjutsu, Black Magic, Summoning, Dark, Demon Arts, Passive: Increase Dagger Power 30%, Maximize Dark Techniques Power 75%, Pierce Lightning Resistance, Cloak of Darkness, Can Equip Fangs, Fang High Mastery+"
]],
    194 => # マーメイド / Mermaid
      [[
        "Beautiful monster with the lower body of a fish. Controls water at will to attack enemies and heal allies. Despite their weak bodies, spells and songs alike make up for their physical shortcomings.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Hat,Magic Hat,Fancy Cap,Buckler",
        "Skills: White Magic,Black Magic,Singing,Ocean",
        "Passive: Sea Strength,Recovery Booster 50%,Sleep Strike +5%",
        "",
      ]],
    195 => # ハイマーメイド / High Mermaid
      [[
        "A high-ranked Mermaid capable of sweeping away hordes of enemies with tsunamis. With knowledge of water magic and healing spells, the high Mermaid makes for a powerful support mage.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: White Magic,Black Magic,Singing,Ocean",
        "Passive: Sea Strength,Recovery Booster 50%",
        "   Sleep Strike +10%",
      ]],
    196 => # ローレライ / Lorelei
      [[
        "A Mermaid that possesses the power to flood a town and submerge it underwater, a power beyond a High Mermaid's capabilities. With a greater grasp of White Magic, the Lorelei is a powerful support unit.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: White Magic,Black Magic,Singing,Ocean",
        "Passive: Super Sea Strength,Recovery Booster 50%",
        "   Sleep Strike +20%",
      ]],
    197 => # 海賊マーメイド / Pirate Mermaid
      [[
        "A Mermaid who excels in swordsmanship that has chosen to walk the Pirate's path. With her unique Piracy and Sword skills, songs that drive allies berserk and the ability to call upon a hurricane, the Pirate Mermaid is a powerful frontline combatant.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Robe,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: White Magic,Piracy,Singing,Ocean",
        "Passive: SP Cost 75%,Sea Strength,Sleep Strike +5%",
        "",
      ]],
    198 => # 海賊王ローレライ / Pirate King Lorelei
      [[
        "A Lorelei with command over Pirate Mermaids, set to conquer the Seven Seas. With powerful Piracy skills at her disposal, the Pirate King Lorelei is a mighty force on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Robe,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: White Magic,Piracy,Singing,Ocean",
        "Passive: SP Cost 50%,Super Sea Strength,Sleep Strike +5%",
        "",
      ]],
    199 => # 行商マーメイド / Mermaid Merchant
      [[
        "A well-respected Mermaid who does business with humans, trading gold for goods and vice versa. Despite her poor survival abilities, the Mermaid Merchant can wield her Mercantile skills to provide support.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: White Magic,Mercantile,Singing,Ocean",
        "Passive: Gold Drop 200%,Sea Strength,Sleep Strike +5%",
        "",
      ]],
    200 => # 海運王ローレライ / Shipping Magnate Lorelei
      [[
        "A Lorelei who controls the battlefield, marketplace, and the Seven Seas with the power of money. With the use of convenient Mercantile skills, like purchasing rare goods in and out of combat, the Merchant Magnate Lorelei is useful in many situations.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: White Magic,Mercantile,Singing,Ocean",
        "Passive: Gold Drop 300%,Super Sea Strength",
        "   Sleep Strike +5%",
      ]],
    201 => # クィーンマーメイド / Queen Mermaid
      [[
        "A Mermaid who resides over her race as a queen, wielding extraordinary magic power. With her unparalleled powers of healing, coupled with her Piracy and Mercantile skills, and topped with the ability to flood towns, the Mermaid Queen is truly a force of nature.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Robe,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: White Magic,Black Magic,Piracy,Mercantile,Singing,Ocean",
        "Passive: Super Sea Strength,Recovery Booster 50%",
        "   Sleep Strike +20%",
      ]],
    202 => # 伝説の神魚
      [[ "The ultimate mermaid said to harbor the power of a distant utopia Their healing power disrupts the cycle of life thus designated as a sealed species Freely manipulates water and ice with extremely high recovery abilities DEF is not low making them reliable as a healing presence",
  "",
  "",
  "",
],
[
  "Equip: Clothes A, Breastplate B, Armor C, Robe A, Hat A, Helmet C, Magic Hat A, Fancy Cap A, Buckler C, Shield C, Skill: White Magic, Black Magic, Piracy, Mercantile, Sing, Ocean, Passive: Recovery Boost, Normal Attack Sleep 40%, Super Sea Strength"
]],
    7418 => # ワールドドロウン
      [[ "A nightmare mermaid that submerged the entire world and destroyed civilizations Even their singing voice possesses the power of destruction denying all life Their healing power has reached its peak enhancing allies with counters With immense magic power and no weaknesses they can fulfill any role",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Breastplate SS, Armor S, Robe SSS, Hat SSS, Helmet S, Magic Hat SSS, Fancy Cap SSS, Buckler S, Shield S, Skill: White Magic, Black Magic, Piracy, Mercantile, Sing, Ocean, Passive: Super Recovery Boost, Normal Attack Sleep 50%, Super Sea Strength, Adds All Status Ailment Cure Effect to Rapid Delay Heal, Frequently Activates Leap Time in Response to Enemy Attacks"
]],
    203 => # エルフ / Elf
      [[
        "Self-proclaimed forest guardians resembling humans, they pride themselves on always hitting their mark. Unfortunately, despite natural buffers against status ailments they're rather weak to pleasure.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Fancy Cap",
        "Skills: Bow,Sexcraft,Demon Arts,Nature",
        "Passive: Eva +10%,Forest Strength,Slayer Boost 100%",
        "",
      ]],
    204 => # ハイエルフ / High Elf
      [[
        "A high-ranked Elf with exceptional skill with a Bow. With arrows that impair enemies and lewd skills to pleasure them, a High Elf is a capable fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Fancy Cap",
        "Skills: Bow,Sexcraft,Demon Arts,Nature",
        "Passive: Eva +10%,Forest Strength,Slayer Boost 100%",
        "",
      ]],
    205 => # マスターエルフ / Master Elf
      [[
        "A highly trained Elf that serves under the Queen Elf, wielding powerful Bow skills that can annihilate groups of enemies. Despite her weak pleasure defense, the Master Elf can petrify enemies, kill them instantly, and resist many ailments with her high stats.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Fancy Cap",
        "Skills: Bow,Sexcraft,Demon Arts,Nature",
        "Passive: Eva +10%,Forest Strength,Slayer Boost 100%",
        "",
      ]],
    206 => # フォレストエルフ / Forest Elf
      [[
        "An Elf related to Fairies, capable of manipulating the forces of nature. By communicating with the forest, she can call upon natural energies to heal allies and strike enemies down.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "Skills: Bow,White Magic,Sexcraft,Demon Arts,Plant,Nature",
        "Passive: Super Forest Strength",
        "",
      ]],
    207 => # ワンダーエルフ / Wonder Elf
      [[
        "A Forest Elf who has mastered the forces of nature, creating earthquakes and gusts to destroy her enemies.  With the ability to gain protection and heal her allies by calling upon nature, the Wonder Elf is an active fighter in many aspects.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "Skills: Bow,White Magic,Sexcraft,Demon Arts,Plant,Nature",
        "Passive: Super Forest Strength",
        "",
      ]],
    208 => # ダークエルフ / Dark Elf
      [[
        "An Elf whose body and soul have been stained by darkness, wielding a sword instead of a bow. Despite the weak defense, a Dark Elf excels with physical strength and can use magic to summon tentacles.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Armor,Robe,Dress,Skimpy,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Sword,Black Magic,Dark,Sexcraft,Demon Arts,Tentacle",
        "   Nature",
        "Passive: Forest Strength",
      ]],
    209 => # アークエルフ / Arc Elf
      [[
        "A Dark Elf who is able to channel destructive black magic through her body. Although her defense is weak, the Arc Elf wields tentacle skills, lethal sword skills, and powerful magic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Armor,Robe,Dress,Skimpy,Hat,Helmet,Magic Hat",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Sword,Black Magic,Dark,Sexcraft,Demon Arts,Tentacle",
        "   Nature",
        "Passive: Forest Strength",
      ]],
    210 => # デュラハン / Dullahan
      [[
        "A headless knight, closely related to Elves, who can learn powerful Sword skills. The Dullahan can amplify their power using Spellblade skills and attack twice with her head and body.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat",
        "   Helmet,Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Sword,Spellblade,Demon Arts",
        "Passive: None",
      ]],
    211 => # ロードデュラハン / Dullahan Lord
      [[
        "A high-ranking Dullahan who is an expert in combat and a master of the sword. Possessing rare sword skills coupled with the art of Spellblade, the Dullahan Lord can easily exploit the vulnerabilities of her enemies. Apart from her lackluster magical power, she has no other significant flaws.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat",
        "   Helmet,Heavy Helmet,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Sword,Spellblade,Demon Arts",
        "Passive: None",
        "",
      ]],
    212 => # クィーンエルフ / Queen Elf
      [[
        "An Elf who rules her kind with mastery over the Bow and all its secrets. With powerful healing spells and the most satisfying Pleasure attacks, the Queen Elf is a mighty force.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Sword,Bow,White Magic,Black Magic,Dark,Spellblade",
        "   Sexcraft,Demon Arts,Plant,Nature",
        "Passive: Eva +10%,Super Forest Strength,Slayer Boost 100%",
      ]],
    213 => # アルフ神族
      [[ "A mysterious ancient race said to be the ancestors of Elves and Humans It is said that they lead a forbidden legion and herald the end of the world. Learns the ultimate bow SKL and ancient magic sword secrets Also possesses resistance to nature attributes and high defensive capabilities",
  "",
  "",
  "",
],
[
  "Equip: Clothes A, Gi A, Armor C, Robe B, Dress B, Skimpy A, Hat A, Helmet C, Magic Hat B, Fancy Cap A, Buckler B, Shield C, Skill: Sword, Bow, White Magic, Black Magic, Magic Sword, Sexcraft, Demon Arts, Plant, Nature, Passive: Enhanced Racial Special Attacks, Enhanced Status Ailment Special Attacks, Alphs Protection, Super Forest Strength"
]],
    7419 => # アンゴルモア
      [[ "The most powerful Alph deity in history known as the King of Terror A mighty and destructive being the genetic origin of the primordial humans. Masters multiple weapons with multiple arms but excels most with the bow and arrow Overall high stats with no noticeable weaknesses",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Gi SSS, Armor S, Robe SS, Dress SS, Skimpy SSS, Hat SSS, Helmet S, Magic Hat SS, Fancy Cap SSS, Buckler SS, Shield S, Skill: Sword, Bow, White Magic, Black Magic, Magic Sword, Sexcraft, Demon Arts, Plant, Nature, Passive: Greatly Enhanced Racial Special Attack, Greatly Enhanced Status Ailment Special Attack, Angolmoiss Protection, Super Forest Strength"
]],
    214 => # フェアリー / Fairy
      [[
        "Playful forest-dwellers resembling humans. Although physically powerless, their alignment with nature calls forth natural forces to attack and heal. High evasion and magic mitigates their pitiful defenses.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Fancy Cap",
        "Skills: White Magic,Black Magic,Dancing,Nature",
        "Passive: Eva +50%,Mag Eva +50%,MP Regen +1%,Gambling Luck I",
        "",
      ]],
    215 => # 風精 / Wind Sprite
      [[
        "A superior fairy that has increased its affinity with the power of wind. As a result of her link with nature, she has gained a further increase in magic power including healing skills and dances that call down tornadoes. However, her defenses are fragile and frontline combat is ill-advised.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Fancy Cap",
        "Skills: White Magic,Black Magic,Dancing,Nature",
        "Passive: Eva +50%,Mag Eva +50%,MP Regen +2%",
        "   Gambling Luck I",
        "",
      ]],
    216 => # 風の精霊 / Wind Spirit
      [[
        "A high-ranked Fairy who has become a spirit of the Wind, wrecking havoc with her devastating gales and harnessing the wrath of nature through dancing. By learning an advanced mana restoration ability, the Wind Spirit can also continuously cast magic spells.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Fancy Cap",
        "Skills: White Magic,Black Magic,Dancing,Nature",
        "Passive: Eva/Mag Eva +50%,MP Regen +4%",
        "   Gambling Luck I",
        "",
      ]],
    217 => # 土精 / Earth Sprite
      [[
        "A Fairy who has adapted to using the Earth element, granting her improved attack and defense power. The Earth Sprite can wield Axes and Clubs in direct combat, but at the cost of lower magical capabilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Hat,Helmet,Buckler,Shield",
        "Skills: Axe,Club,Dancing,Nature",
        "Passive: Crit +15%,Eva/Mag Eva +10%,Battle Start SP 75%",
        "",
      ]],
    218 => # 土の精霊 / Earth Spirit
      [[
        "A high-ranked Fairy who has become a spirit of the Earth, boasting greater fighting power. An Earth Spirit's high defense power and exceptional skill with Axes and Clubs make up for their lackluster magical capabilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Hat,Helmet,Buckler,Shield",
        "Skills: Axe,Club,Dancing,Nature",
        "Passive: Crit +15%,Eva/Mag Eva +10%,Battle Start SP 100%",
        "",
      ]],
    219 => # ダークフェアリー / Dark Fairy
      [[
        "A Fairy who has accepted Darkness into her heart to attain powerful attack magic. A Dark Fairy loves to gamble and is capable of Summoning the beast known as Pegasus.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Fancy Cap",
        "Skills: White Magic,Black Magic,Summoning,Dark,Dancing,Oracle",
        "   Nature",
        "Passive: Eva/Mag Eva +40%,MP Regen +1%,Item Drop 200%",
        "   Gambling Luck II",
      ]],
    220 => # アークフェアリー / Arc Fairy
      [[
        "A high-ranked Fairy who has become one with Darkness, gaining the power to invoke large-scale disasters. Despite not being a strong physical fighter, the Arc Fairy can slay an entire group of enemies thanks to her magic and Oracle skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Fancy Cap",
        "Skills: White Magic,Black Magic,Summoning,Dark,Dancing,Oracle",
        "   Nature",
        "Passive: Eva/Mag Eva +40%,MP Regen +2%,Item Drop 300%",
        "   Gambling Luck III",
        "",
      ]],
    221 => # クィーンフェアリー / Queen Fairy
      [[
        "A Fairy who rules over her kind and commands nature effortlessly due to her tremendous magical power. The Queen Fairy is the embodiment of nature, thanks to a powerful Dancing skill, not to mention her mana regeneration and cost reduction.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Fancy Cap",
        "Skills: White Magic,Black Magic,Summoning,Dark,Oracle,Dancing",
        "   Plant,Nature",
        "Passive: Eva/Mag Eva +50%,MP Regen +4%,MP Cost 50%",
        "   Item Drop 300%,Gambling Luck III",
      ]],
    222 => # コスモフェアリー
      [[ "A fairy extremely powerful with the power of the galaxy Designated as a sealed species because their will alone can disrupt the natural order Said to shake the stars themselves with immense magical power Can also learn ultimate summoning with magic power said to be infinite",
  "",
  "",
  "",
  "",
],
[
  "Equip: Robe A, Fancy Cap A, Skill: White Magic, Black Magic, Summoning, Oracle, Dance, Plant, Nature, Passive: +50% Galaxy Attribute, Recover 6% MP Each Turn, MP Consumption 1/2, 3x Item Drop"
]],
    7420 => # コスモス
      [[ "Said to be the very will of the stars the God Butterfly of Destruction and Protection Said to be able to either nurture life or destroy civilizations at will Possesses overwhelming magic power capable of annihilating everything with the power of the galaxy and is also very fast Additionally it is said to bring various fortunes to those who follow it",
  "",
  "",
  "",
  "",
],
[
  "Equip: Robe SSS, Fancy Cap SSS, Skill: White Magic, Black Magic, Summoning, Oracle, Dance, Plant, Nature, Passive: +100% Galaxy Attribute, Recover 8% MP Each Turn, MP Consumption 1/4, 5x Item Drop"
]],
    223 => # スライム / Slime
      [[
        "A monster composed entirely of slime. Besides using their slimy bodies as a weapon, they're proficient with boomerangs. They can heal allies with slime too. Their bodies are resistant to physical attacks, but susceptible to magic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Robe,Fancy Cap",
        "Skills: Throwing,Slime",
        "Passive: Boomerang Booster 20%,Slimed Strike +10%",
        "",
      ]],
    224 => # メガスライム / Mega Slime
      [[
        "A strong Slime capable of creating a clone of herself and using her body as a weapon. She can attack groups of enemies at once with Throwing skills; however, her magic and elemental defense are very poor.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Robe,Fancy Cap",
        "Skills: Throwing,Slime",
        "Passive: Boomerang Booster 20%,Slimed Strike +20%",
        "",
      ]],
    225 => # ギガスライム / Giga Slime
      [[
        "A top-class Slime that has gained great power, including the ability to split into three clones. The Giga Slime can master powerful Slime and Throwing skills; because her elemental defense is poorly developed, she must take caution when health becomes an issue.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Robe,Fancy Cap",
        "Skills: Throwing,Slime",
        "Passive: Boomerang Booster 20%,Slimed Strike +30%",
        "",
      ]],
    226 => # 癒しのスライム / Heal Slime
      [[
        "A gentle Slime that heals others by activating the metabolism in their bodies. Despite her lackluster attack power, the Heal Slime's [Aqua Shield], as well as her healing and other support skills are top notch.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Robe,Fancy Cap",
        "Skills: White Magic,Throwing,Slime",
        "Passive: Boomerang Booster 20%",
        "   Slimed Strike +20%",
      ]],
    227 => # 破邪の粘妖 / Purifying Slime
      [[
        "A high-ranked Slime with advanced healing powers and Throwing skills that destroy evil on the spot. The Purifying Slime can learn many powerful healing spells and other useful skills, making her a versatile support character.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Robe,Fancy Cap",
        "Skills: White Magic,Throwing,Slime",
        "Passive: Boomerang Booster 20%,Slimed Strike +30%",
        "",
      ]],
    228 => # 肉食スライム / Carnivorous Slime
      [[
        "A Slime that has developed a taste for devouring live creatures by wrapping them up in her slime and digesting them whole. The Carnivorous Slime can coat enemies in her juices using her boomerang or through counter-attacks; as a last resort, she can self-destruct to cause considerable damage.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Robe,Fancy Cap",
        "Skills: Throwing,Slime",
        "Passive: Boomerang Booster 20%,Digestion Strike +10%",
        "",
      ]],
    229 => # 淫酷の粘妖 / Malicious Slime
      [[
        "A cruel high ranking Slime who captures groups of prey and devours them all. The Malicious Slime acquires aggressive Slime abilities with predatorial effects as well as powerful Throwing skills, making her a specialized offensive combatant.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Robe,Fancy Cap",
        "Skills: Throwing,Slime",
        "Passive: Boomerang Booster 20%,Digestion Strike +20%",
        "",
      ]],
    230 => # クィーンスライム / Queen Slime
      [[
        "The ultimate slime who stands above all others. Has incorporated countless beings within their body and become a colony lifeform. Learns secret Boomerang skills in addition to powerful attacks utilizing their slime body. Also learns various other skills such as self-destruction and protective magic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Robe,Fancy Cap",
        "Skills:White Magic,Throwing,Slime",
        "Passive:Slime Strike 30%,Digestion Strike 20%,Boomerang Booster 30%",
      ]],
    231 => # 究極群体生命
      [[ "A forbidden collective lifeform composed of billions of lives Designated as a sealed species by the gods for disrupting the balance of the world Learns ultimate Boomerang SKL and SKL utilizing their collective body Their vitality is among the highest of all races",
  "",
  "",
  "",
  "",
],
[
  "Equip: Shell A, Robe A, Fancy Cap A, Skill: White Magic, Throwing, Slime, Passive: Increase Boomerang Power 30%, Normal Attack Slippery 40%, Normal Attack Digestion 30%"
]],
    7421 => # カナデ
      [[ "Known as the primordial collective lifeform revered as the ancestral god among slimes Boasts power that can fill the world with their own life their abilities are overwhelming Can learn powerful slime SKL such as the ultimate division technique Weak to attribute attacks and status ailments but boasts unparalleled DEF in physical aspects",
  "",
  "",
  "",
  "",
],
[
  "Equip: Shell SSS, Robe SSS, Fancy Cap SSS, Skill: White Magic, Throwing, Slime, Passive: Increase Boomerang Power 30%, Normal Attack Slippery 75%, Normal Attack Digestion 50%, No Ability Reduction When Splitting"
]],
    232 => # 魔獣 / Beast
      [[
        "A type of monster with pronounced animal features. Beasts are fast and tear at their enemies with fang and claw. Their attack power, agility, and evasion are excellent, but their defense is low, especially against pleasure. They specialize in offense.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Breastplate,Shell,Fancy Cap",
        "Skills: Beast",
        "Passive: Crit +15%,Counter +25%,Eva +20%,Fang Booster 20%",
        "",
      ]],
    233 => # ルナティックビースト / Lunatic Beast
      [[
        "A strong Beast who goes on a rampage to tear her enemies apart. To make up for their lackluster Agility, the Lunatic Beast can go berserk at will to gain massive power at the cost of losing control.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Breastplate,Shell,Fancy Cap",
        "Skills: Beast",
        "Passive: Crit +30%,Counter +25%,Eva +20%",
        "   Fang Booster 20%",
      ]],
    234 => # 血塗られた狂獣 / Blood-Crazed Beast
      [[
        "A Beast who has developed overwhelming power, making her able to crush anything that stands in her way. By mastering destructive Beast skills, the Blood-Crazed Beast increases her power to extreme heights, despite her lower defensive capabilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Breastplate,Shell,Fancy Cap",
        "Skills: Beast",
        "Passive: Crit +30%,Counter +25%,Eva +20%",
        "   Battle Start Preemptive War Cry 50%",
        "   Fang Mastery,Fang Booster 20%",
      ]],
    235 => # スピードビースト / Speed Beast
      [[
        "A Beast with overwhelming speed, capable of taking down enemies with consecutive combo attacks. The Speed Beast's blinding speed allows her to effortlessly evade attacks and steal the enemy's items in the blink of an eye.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Breastplate,Shell,Fancy Cap",
        "Skills: Thievery,Beast",
        "Passive: Crit +15%,Counter +50%,Eva +30%",
        "   Fang Booster 20%,Blind Strike +10%",
        "",
      ]],
    236 => # 疾空の魔獣 / Sonic Beast
      [[
        "A Beast who runs like the wind, launching continuous attacks faster than the eye can see. The Sonic Beast is so fast, she can even steal items from her enemies as she attacks them; due to her low defense, she has developed extremely high agility to avoid deadly attacks.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Breastplate,Shell,Fancy Cap",
        "Skills: Thievery,Beast",
        "Passive: Crit +15%,Counter +75%,Eva +30%,Fang Mastery",
        "   Fang Booster 20%,Blind Strike +20%",
        "",
      ]],
    237 => # ミノタウロス / Minotaur
      [[
        "Famous half-bull creatures, legendary for their strength and their power with an Axe. The Minotaur's defense is substantial, making her a sturdy physical fighter for the frontline of a battlefield; however, her agility and magic defense are lacking, so take caution when facing enemies with speed and magic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Hat,Fancy Cap",
        "Skills: Axe,Club,Flail,Beast",
        "Passive: Crit +30%",
        "",
      ]],
    238 => # ギガタウロス / Giga Minotaur
      [[
        "A top-ranking Minotaur who boasts both extremely high offensive and defensive capabilities. While unable to use magic effectively, the Giga Minotaur is a master of Axe skills, making her the apex fighting machine able to crush everything in her path.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Hat,Fancy Cap",
        "Skills: Axe,Club,Flail,Beast",
        "Passive: Crit +30%",
        "",
      ]],
    239 => # ケンタウロス / Centaur
      [[
        "A monster with the body of a horse, possessing outstanding speed and high combat capabilities. To make up for her poor defense, the Centaur develops great evasion and learns many Spear skills, allowing her to charge into battle.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Armor,Hat,Helmet,Fancy Cap,Buckler,Shield",
        "Skills: Rapier,Spear,Beast",
        "Passive: Crit +15%,Eva +30%",
        "",
      ]],
    240 => # グランセントール / Grand Centaur
      [[
        "A high-ranking Centaur boasting outstanding leg strength and fighting ability, charging like a gale wielding powerful Spear skills. The Grand Centaur can adapt her speed to act twice in combat and overwhelm her enemies with unrivaled agility, making her a powerful attack force.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Armor,Hat,Helmet,Fancy Cap,Buckler,Shield",
        "Skills: Rapier,Spear,Beast",
        "Passive: Crit +15%,Eva +30%",
        "",
      ]],
    241 => # ねこまた / Nekomata
      [[
        "A monster with a cat's body, boasting excellent agility and fighting sense hidden under the disguise of a lax attitude. To make up for her poor defense, the Nekomata learns amazing Unarmed attacks, unique Dancing skills, and develops incredible evasion.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Gi,Breastplate,Shell,Hat,Fancy Cap",
        "Skills: Unarmed,Dancing,Beast",
        "Passive: Crit +15%,Counter +50%,Eva +20%",
        "   Fang Booster 20%,Blind Strike +10%",
        "",
      ]],
    242 => # 武神キャット / Martial God Cat
      [[
        "A superior Nekomata with extraordinary physical capabilities, using their incredible Unarmed skills to overwhelm her enemies. With extreme agility for avoiding enemy attacks and wild dances, the Martial God Cat is a powerful offensive fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Gi,Breastplate,Shell,Hat,Fancy Cap",
        "Skills: Unarmed,Dancing,Beast",
        "Passive: Crit +15%,Counter +75%,Eva +20%,Fang Booster 20%",
        "   Fang Mastery,Blind Strike +20%",
        "",
      ]],
    244 => # 百獣王
      [[ "A legendary Beast King said to reign at the pinnacle of all beasts Sealed by the gods due to rampaging during the Great Monster Wars Possesses extremely high ATK and agility learning multiple powerful Beast SKL Has weaknesses in defense but covers it with high evasion rate",
  "",
  "",
  "",
],
[
  "Equip: Gi B, Breastplate A, Armor C, Shell A, Hat A, Fancy Cap B, Buckler C, Shield C, Skill: Axe, Club, Flail, Unarmed, Time Magic, Thievery, Dance, Beast, Passive: Fang Power +30%, Normal Attack Blind 40%, Can Equip Fangs, Fang Mastery+"
]],
    7422 => # 時の神獣
      [[ "A chaotic divine beast said to manage time Designated as a forbidden species by the gods due to being an entity belonging to the administrator Freely manipulates time and travels between different spaces Also possesses tremendous power as a beast capable of learning the ultimate beast SKL",
  "",
  "",
  "",
],
[
  "Equip: Gi SS, Breastplate SSS, Armor S, Shell SSS, Robe S, Hat SSS, Fancy Cap SS, Buckler S, Shield S, Skill: Axe, Club, Flail, Unarmed, Time Magic, Thievery, Dance, Beast, Passive: Fang Power +30%, Normal Attack Blind 50%, Can Equip Fangs, Fang High Mastery+, Frequently Activates Leap Time"
]],
    245 => # 妖狐 / Kitsune
      [[
        "Mysterious and mischievous fox girl. Makes for a decent magician with an adequate magic stat and spells from Yamatai. Learns a wide array of fluffy pleasure skills in addition to earth spells.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Magic Hat,Fancy Cap,Buckler,Shield",
        "Skills: Fan,Black Magic,Taoism,Ninjutsu,Beast,Nature",
        "Passive: Mag Eva +10%,SP Regen +5%,Fan Booster 20%",
        "",
      ]],
    246 => # 中級妖狐 / Mid-Rank Kitsune
      [[
        "A Kitsune who has gathered a large amount of spiritual energy, possessing high magical power. The Mid-Rank Kitsune is a reliable fighter with high resistance to ailments, using her characteristic tails to attack in conjunction with her Ninjutsu and Taoism skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Dress,Skimpy,Hat",
        "   Helmet,Magic Hat,Fancy Cap,Buckler,Shield",
        "Skills: Fan,Black Magic,Taoism,Ninjutsu,Beast,Nature",
        "Passive: Mag Eva +10%,SP Regen +5%,Fan Booster 20%",
        "",
      ]],
    247 => # 上級妖狐 / High-Rank Kitsune
      [[
        "A highly-trained Kitsune with immense levels of spiritual energy who has mastered powerful Taoism and Ninjutsu skills. The High-Ranked Kitsune has excellent overall stats and is able to manipulate the Earth both offensively and defensively, making her a versatile fighter in any role.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Dress,Skimpy,Hat",
        "   Helmet,Magic Hat,Fancy Cap,Buckler,Shield",
        "Skills: Fan,Black Magic,Taoism,Ninjutsu,Beast,Nature",
        "Passive: Mag Eva +10%,SP Regen +5%,Fan Booster 20%",
        "",
      ]],
    248 => # 狐魔獣 / Bestial Kitsune
      [[
        "A Kitsune who has reverted back to her bestial origins, losing some magical capabilities in favor of superior strength. The Bestial Kitsune fights with her powerful fangs and claws, using first-class speed to avoid attacks at a high rate.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Gi,Breastplate,Robe,Dress,Skimpy,Hat",
        "   Fancy Cap",
        "Skills: Taoism,Ninjutsu,Beast,Nature",
        "Passive: Crit +15%,Eva +20%,SP Regen +10%,Rumble",
        "   Fang Booster 20%",
      ]],
    249 => # 上級狐魔獣 / Feral Kitsune
      [[
        "A high-ranking Kitsune who fights like a wild animal, launching powerful physical attacks with a strong body. A Feral Kitsune can use the power of Earth-based Taoism, making her both a mighty physical and magical fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Gi,Breastplate,Robe,Dress,Skimpy,Hat",
        "   Fancy Cap",
        "Skills: Taoism,Ninjutsu,Beast,Nature",
        "Passive: Crit +15%,Eva +20%,SP Regen +20%,War Rumble",
        "   Fang Booster 20%",
      ]],
    250 => # 狐芸者 / Kitsune Geisha
      [[
        "A Kitsune trained in the ways of a geisha, able to Sing, Dance, and Cook her way through battle. The Kitsune Geisha is not much of a fighter, but with her skill with a Fan and her other abilities, she is a strong support companion.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Fan,Taoism,Ninjutsu,Dancing,Singing,Cooking,Sexcraft",
        "   Beast,Nature",
        "Passive: Eva/Mag Eva +10%,SP Regen +5%,Fan Booster 20%",
      ]],
    251 => # 狐花魁 / Kitsune Courtesan
      [[
        "A high-ranking kitsune who mastered the ways of the geisha, learning Singing, Dancing, and Cooking skills that greatly damage her enemies. With knowledge of many support skills and mastery of the Fan, the Kitsune Courtesan is an invaluable ally on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Fan,Taoism,Ninjutsu,Dancing,Singing,Cooking,Sexcraft",
        "   Beast,Nature",
        "Passive: Eva +10%,Mag Eva +10%,SP Regen +5%,Fan Booster 20%",
        "",
      ]],
    252 => # 九尾の狐 / Nine-tailed Kitsune
      [[
        "The greatest kitsune who bears nine tails. Proud of her strength, she can destroy her surroundings with a boisterous dance of tails. Her magic is immense and she can use sealed jutsus and talismans. She's skilled with fans, and boasts overall high stats.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Dress,Skimpy,Hat,",
        "Helmet,Magic Hat,Fancy Cap,Buckler,Shield",
        "Skills: Fan,Black Magic,Taoism,Ninjutsu,Dancing,Singing,",
        "Cooking,Sexcraft,Beast,Nature",
        "Passive: SP Regen +30%,Fan Booster 20%",
        "",
      ]],
    253 => # 零尾の狐
      [[ "The ultimate fox spirit said to exist above the Nine-Tailed Fox Their tails extend into imaginary dimensions unobservable from the present world Connected to the power of chaos designated as a sealed species by the gods Overall high stats excelling in magic and various job SKL",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes A, Gi B, Breastplate B, Armor B, Robe A, Dress A, Skimpy A, Hat A, Helmet B, Magic Hat A, Fancy Cap A, Buckler B, Shield B, Skill: Fan, Black Magic, Taoism, Ninjutsu, Dance, Sing, Cooking, Sexcraft, Beast, Nature, Passive: Fan Power +30%, Pierce Earth Resistance, Recover 20% SP Every Turn, MP Recovery 4% per Turn"
]],
    7423 => # 白面金毛九尾の狐
      [[ "A forbidden fox spirit that has unleashed all its power Said to devour the moon and destroy the world designated as a sealed species Boasts immense magical power mastering forbidden secret arts Can learn ultimate SKL in Taoism Ninjutsu and Fan SKL",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Gi SS, Breastplate SS, Armor SS, Robe SSS, Dress SSS, Skimpy SSS, Hat SSS, Helmet SS, Magic Hat SSS, Fancy Cap SSS, Buckler SS, Shield SS, Skill: Fan, Black Magic, Taoism, Ninjutsu, Dance, Sing, Cooking, Sexcraft, Beast, Nature, Passive: Fan Power +30%, Pierce Earth Resistance, Recover 30% SP Every Turn, MP Recovery 8% per Turn, All  Power Depends on Magic"
]],
    254 => # ラミア / Lamia
      [[
        "A type of monster with the lower body of a snake. They use their giant tails as a weapon, and their thick, scaly hide provides good defense. They excel with flails and learn powerful offensive skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Flail,Demon Arts,Snake",
        "Passive: Flail Booster 20%,Stun Strike +10%",
        "",
      ]],
    255 => # ラミアンボア / Boa Lamia
      [[
        "A Lamia who enjoys the cruelty of constricting her prey before swallowing them whole. With her strong defense and her ability to wield flails as if they were her own tail, the Boa Lamia is a powerful frontline fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Flail,Demon Arts,Snake",
        "Passive: Flail Booster 20%,Stun Strike +20%",
        "",
      ]],
    256 => # ラミアンナイトメア / Nightmare Lamia
      [[
        "A high-ranking Lamia who takes the cruelty of winding around her prey and swallowing them whole to another level. With her outstanding defense and the ability to mow down groups of enemies with her incredible Flail skills, the Nightmare Lamia is a force of destruction.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Flail,Demon Arts,Snake",
        "Passive: Flail Booster 20%,Stun Strike +30%",
        "",
      ]],
    257 => # シスターラミア / Lamia Nun
      [[
        "A Lamia who has achieved the power to heal through devotion to her faith. True to her nature as a Lamia, she can restrain enemies with her tail in a gentle hug; although the Lamia Nun is a capable physical fighter, she is more proficient at magic, allowing her to fight as a magician using holy spells.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Flail,White Magic,Demon Arts,Snake",
        "Passive: Flail Booster 20%,Stun Strike +10%",
        "",
      ]],
    258 => # 慈愛の聖蛇 / Lamia Saint
      [[
        "A high-ranking Lamia who brings the miracle of healing fueled by compassion to all her allies. With reliable defensive powers and the ability to use Holy attacks to slay enemies, the Lamia Saint is a reliable supporter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Flail,White Magic,Demon Arts,Snake",
        "Passive: Flail Booster 20%,Stun Strike +20%",
        "",
      ]],
    259 => # 蛇巫女 / Snake Miko
      [[
        "A Lamia with a gentle heart who trained both her mind and body to become a miko. With her powerful flail skills and dances that can drive nature wild, the Snake Miko can stand her ground against anybody.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Robe,Skimpy,Hat,Fancy Cap,Buckler",
        "Skills: Flail,Dancing,Demon Arts,Snake",
        "Passive: Flail Booster 20%,Stun Strike +10%",
        "",
      ]],
    260 => # 白蛇神楽 / White Snake Kagura
      [[
        "The highest class of Snake Miko who dedicates both body and soul to her deity. Wielding godly skill with a Flail and mysterious dances that both bring benefits and crushes her enemies, the White Snake Kagura is one of the best support races.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Flail,Dancing,Demon Arts,Snake",
        "Passive: Flail Booster 20%,Stun Strike +20%",
        "",
      ]],
    261 => # メデューサ / Medusa
      [[
        "A Lamia who has snakes for hair rather than a serpentine lower body, possessing the ability to petrify foes with a glance. Despite not being able to wear hats and helmets because of the snakes in her hair, the Medusa can learn and execute powerful Flail skills to mow down enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Buckler,Shield",
        "Skills: Flail,Demon Arts,Snake",
        "Passive: Counter +50%,Flail Booster 20%",
        "",
      ]],
    262 => # ロードメデューサ / Medusa Lord
      [[
        "A high-rank Medusa with both snakes for hair and a serpentine lower body. With the ability to destroy groups of enemies with both powerful Flail skills and her petrification gaze coupled with her high overall stats, the Medusa Lord is a versatile companion to have.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Buckler,Shield",
        "Skills: Flail,Demon Arts,Snake",
        "Passive: Counter +75%,Flail Booster 20%",
        "",
      ]],
    263 => # クィーンラミア / Queen Lamia
      [[
        "A Lamia who reigns over her race, wielding every single skill of magic and power that her ancestors learned before her. With her high overall stats and mastery over Flails, Dancing, and other offensive skills, the Lamia Queen is one of the most active members of any party.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap,Buckler,Shield",
        "Skills: Flail,White Magic,Dancing,Demon Arts,Snake",
        "Passive: Flail Booster 20%,Stun Strike +30%",
        "",
      ]],
    264 => # ウロボロス
      [[ "A chaotic serpent demon symbolizing infinity Their power is extremely immense and designated as a sealed species by the gods Capable of learning extremely powerful Flail and Serpent SKL Boasts extremely high vitality and DEF demonstrating unparalleled strength as a frontliner",
  "",
  "",
  "",
],
[
  "Equip: Clothes C, Gi C, Breastplate A, Armor A, Robe C, Skimpy C, Hat C, Helmet A, Fancy Cap C, Buckler A, Shield A, Skill: Flail, White Magic, Dance, Demon Arts, Snake, Passive: Flail Power +30%, Counter 75%, Normal Attack Stun 40%, Enhanced When Near Death"
]],
    7424 => # 淫欲の堕蛇
      [[ "A demonic serpent lurking in the divine paradise corrupting humans Designated as a forbidden species by the gods for causing the fall of all humanity Corrupts everything with powerful pleasure and constriction SKL Learns the ultimate flail secret art with combat capabilities rivaling gods",
  "",
  "",
  "",
],
[
  "Equip: Clothes S, Gi S, Breastplate SSS, Armor SSS, Robe S, Skimpy S, Hat S, Helmet SSS, Fancy Cap S, Buckler SSS, Shield SSS, Skill: Flail, White Magic, Dance, Demon Arts, Snake, Passive: Flail Power +30%, Counter 100%, Normal Attack Stun 75%, Super Enhanced When Near Death, Flail and Serpent  Ignore DEF, Activates Infinite Serpent Dance When Allies Are Restrained"
]],
    265 => # スキュラ / Scylla
      [[
        "A monster with multiple soft tentacles for a lower body. They can use their tentacles like whips, attacking enemies repeatedly. Scylla also learn very powerful dual wielding skills. However, their defense is poor.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Robe,Skimpy,Hat,Fancy Cap",
        "Skills: Multiweapon,Tentacle",
        "Passive: Triple Attack,Whip Booster 20%",
        "",
      ]],
    266 => # ハイスキュラ / High Scylla
      [[
        "A highly trained Scylla who has improved her skill with Tentacles, launching continuous attacks to deal significant damage to her enemies. Although her low defenses make her rather fragile, the High Scylla is able to use her many tentacles to pleasure her enemies with gentle caresses.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Robe,Skimpy,Hat,Fancy Cap",
        "Skills: Multiweapon,Tentacle",
        "Passive: Triple Attack,Tentacle Skills *2",
        "   Whip Booster 20%",
      ]],
    267 => # エルダースキュラ / Elder Scylla
      [[
        "A Scylla of the highest rank, able to use her strong tentacles to attack or give pleasure to enemies like an unyielding storm. The Elder Scylla is an expert at using her tentacles, able to attack thrice in a row and restrain foes with exceptional power, making her an unparalleled offensive force from the depths of the sea.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Robe,Skimpy,Hat,Fancy Cap",
        "Skills: Multiweapon,Tentacle",
        "Passive: Triple Attack,Tentacle Skills *2",
        "   Whip Booster 20%",
        "",
      ]],
    268 => # サムライスキュラ / Scylla Samurai
      [[
        "A Scylla trained in the ways of the Samurai, wielding multiple swords in her tentacles and annihilating groups of enemies with a storm of slashes. The Scylla Samurai learns skills that can hinder enemies as well as strike down groups of them with a single attack. However, she leaves herself vulnerable on the battlefield by focusing everything into attack.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap",
        "Skills: Katana,Multiweapon,Tentacle",
        "Passive: Dual Wield,Double Attack",
        "",
      ]],
    269 => # 天下無双スキュラ / Peerless Scylla Samurai
      [[
        "A Scylla Samurai who has attained higher power, wielding even more swords in her tentacles to bring countless slashes to her enemies. The Peerless Scylla Samurai has fragile defenses, but compensates by learning a variety of powerful Katana and Multiweapon skills.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap",
        "Skills: Katana,Multiweapon,Tentacle",
        "Passive: Dual Wield,Double Attack",
        "",
      ]],
    270 => # スキュラメイド / Scylla Maid
      [[
        "A Scylla who has been trained as a maid, using her tentacles to Service both allies and enemies. To compensate for her low stats excluding Dexterity, the Scylla Maid has useful healing abilities with her Maid skills, making her a capable support unit.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Robe,Skimpy,Hat,Fancy Cap",
        "Skills: Service,Tentacle",
        "Passive: Eva +10%,Triple Attack",
      ]],
    271 => # スキュラサーバント / Scylla Servant
      [[
        "A highly trained Scylla Maid whose superior Service skills are supplemented by her countless tentacles. The Scylla Servant is better suited for support instead of direct combat; however, she can use pleasurable Service skills to immerse enemies in ecstasy.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Robe,Skimpy,Hat,Fancy Cap",
        "Skills: Service,Tentacle",
        "Passive: Eva +10%,Triple Attack",
        "",
      ]],
    272 => # クィーンスキュラ / Queen Scylla
      [[
        "A Scylla who rules over her kind, using her mastery of Tentacles to attack, restrain, and pleasure her enemies. Despite her troublesome defense, the Queen Scylla has high combat capability through the use of multiple weapons.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Robe,Skimpy,Hat,Helmet",
        "   Fancy Cap",
        "Skills: Katana,Multiweapon,Service,Tentacle",
        "Passive: Chaotic Attack,Tentacle Skills *2",
        "   Whip Booster 20%",
      ]],
    273 => # インフィニティスキュラ
      [[ "The ultimate Scylla with infinite tentacles During the Great Monster Wars they plunged the angel army into a tentacle hell and were designated as a sealed species Their overwhelming number of consecutive attacks deals significant damage to enemies They excel in offense but are weak in defense so caution is needed",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes A, Unarmed Wear A, Breastplate B, Armor C, Robe C, Light Clothing C, Hat A, Helmet C, Luxury Hat B, Skill: Katana, Multiweapon, Service, Tentacle, Passive: Barrage, Activate Tentacle  Twice, Whip Power +30%, Tentacle  Combo Count +1"
]],
    7425 => # 正体不明触手禍
      [[ "A very mysterious tentacle life form Possessing the genes of a tentacle creature from another world designated as a forbidden species by the gods Said to cover the world with tentacles and torment all living things Can learn ultimate tentacle SKL and is SKLed with multiple weapons",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Gi SSS, Breastplate SS, Armor S, Robe S, Skimpy S, Hat SSS, Helmet S, Fancy Cap SS, Skill: Katana, Multiweapon, Service, Tentacle, Passive: Master Barrage, Activate Tentacle  Thrice, Whip Power +30%, Tentacle  Combo Count +2"
]],
    274 => # ハーピー / Harpy
      [[
        "Flying monster girls with big wings, they glide around enemy attacks with ease. They also learn energetic dances to boost stats and morale. Proficient at stealing too, but can't take a lot of hits.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Skimpy,Hat,Fancy Cap",
        "Skills: Fan,Thievery,Dancing,Wing",
        "Passive: Eva/Mag Eva +40%,Fan Booster 20%",
        "",
      ]],
    275 => # ウィングハーピー / Wing Harpy
      [[
        "A Harpy with enormous wings that allow her to fly at exceptional speeds and avoid enemy attacks. While the Wing Harpy's combat ability isn't high, she is well suited to provide support with her Dance skills and ability to steal items from enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Skimpy,Hat,Fancy Cap",
        "Skills: Fan,Thievery,Dancing,Wing",
        "Passive: Eva/Mag Eva +40%,Fan Booster 20%",
        "",
      ]],
    276 => # エルダーハーピー / Elder Harpy
      [[
        "A high ranking Harpy who dominates the sky with her strong wings that stir up gusts of Wind and help her avoid enemy attacks. The Elder Harpy's powerful Thievery skills and her inspirational Dances make her effective at supporting her allies, to compensate for not being fully capable in combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Skimpy,Hat,Fancy Cap",
        "Skills: Fan,Thievery,Dancing,Wing",
        "Passive: Eva/Mag Eva +40%,Fan Booster 20%",
        "",
      ]],
    277 => # ハーピーナイト / Harpy Knight
      [[
        "An unconventional Harpy who trains in the ways of a Knight, overwhelming enemies with a barrage of spear thrusts augmented by her tremendous speed. The Harpy Knight is capable of using her unique Warrior's Dance to enhance her offensive strength, however her defense is low despite the ability to equip breastplates.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Skimpy,Hat,Helmet",
        "   Fancy Cap",
        "Skills: Spear,Thievery,Dancing,Wing",
        "Passive: Eva/Mag Eva +30%",
        "",
      ]],
    278 => # スカイハイ / Sky Knight
      [[
        "A high ranking Harpy Knight who soars through the heavens, using refined Spear skills to subdue her enemies with the force of gale. The Sky Knight can perform a Hero's Dance to enhance her own power; however, she sacrifices defensive capabilities to focus everything into offense.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Skimpy,Hat,Helmet",
        "   Fancy Cap",
        "Skills: Spear,Thievery,Dancing,Wing",
        "Passive: Eva/Mag Eva +30%",
        "",
      ]],
    279 => # エイビス / Aevis
      [[
        "A Harpy who acts and fights like a rabid beast, using her high physical prowess to rip enemies apart with tooth and talon. The Aevis can strike at foes with great gusts of wind and even breathe fire; however, she sacrifices magical capabilities to supplement her incredible combat prowess.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Breastplate,Hat,Fancy Cap",
        "Skills: Thievery,Beast,Wing,Breath",
        "Passive: Crit +15%,Eva +30%,Fang Booster 20%",
        "",
      ]],
    280 => # ガルーダ / Garuda
      [[
        "A Harpy known as the \"God Bird\", possessing overwhelming physical power and eliminating enemies without mercy. Armed with various Beast, Breath, and Wing skills, the Garuda is an excellent attack force of immense power.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Breastplate,Hat,Fancy Cap",
        "Skills: Thievery,Beast,Wing,Breath",
        "Passive: Crit +15%,Eva +30%,Fang Booster 20%",
        "",
      ]],
    281 => # クィーンハーピー / Queen Harpy
      [[
        "A Harpy who rules over her kind with beauty and grace. With mastery over Beast, Breath, Dancing, Fan, Spear, Thievery, and Wing skills, the Queen Harpy is a powerful fighter with both offensive and supportive capabilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Armor,Skimpy,Hat,Helmet",
        "   Fancy Cap",
        "Skills: Spear,Fan,Thievery,Dancing,Beast,Wing,Breath",
        "Passive: Eva/Mag Eva +40%,Fan Booster 20%",
        "",
      ]],
    282 => # 神鳥
      [[ "Said to be the ruler of the sky with great power Their power is said to step into the realm of gods thus sealed Learns the ultimate secret arts of spears and fans boasting extraordinary martial strength Despite low DEF their incredible evasion makes it difficult for them to take damage",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes B, Gi B, Breastplate A, Armor C, Skimpy A, Hat A, Helmet C, Fancy Cap A, Skill: Spear, Fan, Thievery, Dance, Beast, Wing, Breath, Passive: Fan Power +30%, Auto Revive Once Upon Defeat"
]],
    7426 => # フェニックス
      [[ "A cosmic wave lifeform that has taken the form of a blazing giant bird Possessing immortal vitality designated as a forbidden species by the gods Controls life energy and is said to return all of a planet to nothingness No matter how many times they are defeated they revive undeterred by their weak defense",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Breastplate SSS, Armor S, Skimpy SSS, Hat SSS, Helmet S, Fancy Cap SSS, Skill: Spear, Fan, Thievery, Dance, Beast, Wing, Breath, Passive: Fan Power +30%, Auto Revive Thrice Upon Defeat"
]],
    283 => # ドラゴン / Dragon
      [[
        "Powerful monster girl famed for their strength. Fangs and claws alike wield fantastic power. With its trademark fire breath and excellent stats, this race screams reliability.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Breastplate,Armor,Heavy Armor,Hat,Helmet",
        "   Heavy Helmet,Buckler,Shield,Heavy Shield",
        "Skills: Beast,Breath",
        "Passive: Fang Booster 20%",
        "",
      ]],
    284 => # 竜人 / Dragonkin
      [[
        "A Dragon who has developed a humanoid body, retaining her physical superiority. With knowledge of Unarmed and Sword skills coupled with an ability that charges SP at twice the normal speed, the Dragonkin is an encouraging ally to have.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Heavy Armor,Hat,Helmet",
        "   Heavy Helmet,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Unarmed,Beast,Breath",
        "Passive: None",
      ]],
    285 => # 覇竜 / Dragon Conqueror
      [[
        "A high-ranked Dragonkin possessing overwhelming attack, defensive power, and agility. Wielding Unarmed skills that sets her fists ablaze, the Dragon Conqueror is a reliable attack force on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Heavy Armor,Hat,Helmet",
        "   Heavy Helmet,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Unarmed,Beast,Breath",
        "Passive: None",
        "",
      ]],
    286 => # 竜神 / Divine Dragon
      [[
        "A Dragonkin who has evolved to resemble divinity, possessing powerful fire-based magic that could raze anything down to ash. Wielding powerful Black, White, and Time Magic, the Divine Dragon is an active if not robust magical fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Heavy Armor,Robe,Hat,Helmet",
        "   Heavy Helmet,Buckler,Shield,Heavy Shield",
        "Skills: White Magic,Black Magic,Time Magic,Holy,Dark,Beast",
        "   Breath",
        "Passive: None",
      ]],
    287 => # 飛竜 / Wyvern
      [[
        "A Dragon whose body is closer to her ancestors, possessing wings like the others, but able to fly in the sky above. By breathing intense flames, summoning gusts of wind to destroy enemies, and possessing high melee capabilities, the Wyvern is a powerful aerial force.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Breastplate,Armor,Hat,Helmet",
        "Skills: Beast,Wing,Breath",
        "Passive: Eva +10%,Fang Booster 20%",
        "",
      ]],
    288 => # バハムート / Bahamut
      [[
        "A Dragon who rules the skies, wielding combat abilities said to be equal to that of a God. Her low pleasure defenses notwithstanding, a Bahamut can destroy enemies by burning them with roaring flames and blowing them away with her mighty wings.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Breastplate,Armor,Hat,Helmet",
        "Skills: Beast,Wing,Breath",
        "Passive: Eva +10%,Fang Mastery,Fang Booster 20%",
        "",
      ]],
    289 => # 海竜 / Sea Dragon
      [[
        "A Dragon born in the sea who is infamous among seafarers for their ability to cause tsunamis and freeze everything with their breath. With her high defense and possession of more magical power than regular dragons, the Sea Dragon is a very active fighter in many aspects.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Breastplate,Armor,Hat,Helmet",
        "Skills: Beast,Nature,Breath",
        "Passive: Sea Strength,Fang Booster 20%",
        "",
      ]],
    290 => # リヴァイアサン / Leviathan
      [[
        "A legendary Sea Dragon who dominates the vast seas, capable of summoning tsunamis to sink everything down to the bottom of the sea. With the power to freeze any creature accompanied with her high overall stats, the Leviathan is nothing short of a superlative combatant.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Fang,Clothes,Breastplate,Armor,Hat,Helmet",
        "Skills: Beast,Nature,Breath",
        "Passive: Super Sea Strength,Fang Mastery",
        "   Fang Booster 20%",
        "",
      ]],
    291 => # 神竜
      [[ "A dragon that has touched the power of chaos many take the form of dragon swordsmen. Masters demonic SKL and uses top-class sword SKL Also proficient in Unarmed capable of learning dragon Unarmed secrets Their abilities are extremely high making them the pinnacle of physical attackers",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes C, Breastplate B, Armor B, Heavy Armor A, Hat C, Helmet B, Heavy Helmet A, Buckler C, Shield B, Heavy Shield A, Skill: Dagger, Sword, Katana, Magic Sword, Unarmed, Beast, Wing, Nature, Breath, Passive: Can Equip Fangs, SP Charge 3x, Increase Fang Power 30%, Fang Mastery+, Physical Resistance Penetration"
]],
    7427 => # 虚竜
      [[ "The zero-th ancestor erased by the Dark Goddess Praised as the strongest compared to any existence designated as a forbidden species Learns immensely powerful Breath and unique sword SKL Boasts extremely high abilities and resistances surpassing even gods",
  "",
  "",
  "",
],
[
  "Equip: Clothes S,Breastplate SS,Armor SS,Heavy Armor SSS,Hat S,Helmet SS,Heavy Helmet SSS,Buckler S,Shield SS,Heavy Shield SSS,Skill: Dagger, Sword, Katana, Unarmed, White Magic, Black Magic, Time Magic, Holy, Dark, Magic Sword, Beast, Wing, Nature, Breath, Passive: Holy&Dark Skills +50%, Fang Power +50%,Can Equip Fangs,5x SP Charge,Physical Resistance Penetration,No SP use when Crisis,Fang High Mastery+"
]],
    293 => # 陸棲種 / Land-Dweller
      [[
        "A general term for reptilian and amphibian monsters who live on land. They typically have Breath skills and other toxic attacks along with skills to use their bodies as weapons. HP and defense are high, but other stats are mediocre.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Shell,Robe,Hat,Fancy Cap,Buckler",
        "Skills: Slime,Beast,Tentacle,Breath",
        "Passive: Metabolism Up",
        "",
      ]],
    294 => # 陸上魔類 / High Land-Dweller
      [[
        "A high-ranking Land-Dweller whose toughened body is capable of many feats of combat. The High Land-Dweller's exceptional vitality, coupled with her ability to breathe flames and produce strong toxins makes her a balanced fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Shell,Robe,Hat,Fancy Cap,Buckler",
        "Skills: Slime,Beast,Tentacle,Breath",
        "Passive: Super Metabolism",
        "",
      ]],
    295 => # エビルスピーシーズ / Evil Species
      [[
        "A Land-Dweller who has further improved her talent with fiery Breath skills and other abilities using poison. By utilizing a special Breath skill that spreads status effects to entire groups of enemies, she can play an active role on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Shell,Robe,Hat,Fancy Cap,Buckler",
        "Skills: Slime,Beast,Tentacle,Breath",
        "Passive: Ultimate Metabolism",
        "",
      ]],
    296 => # 軟体搾精種 / Leech
      [[
        "A Land-Dweller who uses her mucus-covered body as a weapon. The Leech can use her unique body to bring pleasure to her enemies, and resist strong blows thanks to her high defense.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Shell,Robe,Hat,Fancy Cap,Buckler",
        "Skills: Slime,Beast,Tentacle,Breath",
        "Passive: Metabolism Up,Slimed Strike +20%",
        "",
      ]],
    297 => # ハイクリーチャー / High Creature
      [[
        "A top-grade Land-Dweller with the ability to produce amazing mucus, using it to pleasure enemies and even melt them in digestive juices. Thanks to her overall balanced stats, the High Creature has no trouble fitting into any role on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Shell,Robe,Hat,Fancy Cap,Buckler",
        "Skills: Slime,Beast,Tentacle,Breath",
        "Passive: Super Metabolism,Null Dmg <= 300",
        "   Slimed Strike +30%",
        "",
      ]],
    298 => # 魔物狩り狩り / Monster Hunter-Hunter
      [[
        "An anti-hunter expert who hunts monster hunters. Specializes in bows and acquires skills to turn the tables against hunters. They're especially strong against Humans and Elves, and are able to strengthen their species-slayer attacks. While not particularly good with magic, they make up for it with their bow proficiency.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Shell,Robe,Hat,Fancy Cap",
        "Skills: Bow,Slime,Beast,Tentacle,Breath",
        "Passive: Eva +10%,Metabolism Up,Nullify Ambush",
        "   Preemptive Strike Up,Endure,Slayer Boost 100%",
      ]],
    299 => # 巨人殺し / Giant Slayer
      [[
        "A high-ranking Monster Hunter specifically trained to exterminate Giants. By learning a variety of Bow skills built for hunting prey both large and small, the Giant Slayer is an excellent long-ranged attacker.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Shell,Robe,Hat,Fancy Cap",
        "Skills: Bow,Slime,Beast,Tentacle,Breath",
        "Passive: Eva +10%,Super Metabolism,Nullify Ambush",
        "   Preemptive Strike Up,Super Endure,Slayer Boost 100%",
        "",
      ]],
    300 => # 百魔の王
      [[ "The ruler standing at the pinnacle of all land monsters Designated as a sealed species by the gods for being the savior of monsters Their toxins and slime are said to plunge the world into chaos Capable of learning extremely powerful Breath and Slime SKL",
  "",
  "",
  "",
],
[
  "Equip: Clothes C, Gi C, Breastplate B, Shell A, Robe C, Hat A, Fancy Cap B, Buckler C, Skill: Bow, Slime, Beast, Tentacle, Breath, Passive: Ultimate Metabolism, Nullify Ambush, Preemptive Strike Up, Super Endure, Nullify Damage <= 3000"
]],
    7428 => # 次元侵蝕者
      [[ "An unidentified tentacle slime lifeform invading from another dimension Fills the world with tentacles and slime a presence that even gods fear Boasts extremely high defensive capabilities and exceptional vitality The SKL that can be learned are extremely powerful demonstrating unparalleled strength",
  "",
  "",
  "",
],
[
  "Equip: Clothes S, Gi S, Breastplate SS, Shell SSS, Robe S, Hat SSS, Fancy Cap SS, Buckler S, Skill: Bow, Slime, Beast, Tentacle, Breath, Passive: Ultimate Metabolism, Nullify Ambush, Preemptive Strike Up, Super Endure, Nullify Damage <= 50000, Auto-Devour at Turn End"
]],
    301 => # 海棲種 / Sea-Dweller
      [[
        "A general term for monsters who live in and around the seas and oceans. They use tentacles as weapons, and some spew ink or bubbles. Their defense is better than the land-dwellers, but attack power is somewhat inferior.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Fancy Cap,Buckler",
        "Skills: Ocean,Tentacle",
        "Passive: Sea Strength",
        "",
      ]],
    302 => # 海洋搾精種 / Sea Leech
      [[
        "A Leech who dwells in the ocean, using her tentacles to strike down her enemies. The Sea Leech can summon a tsunami with her magic and possesses a strong body with above average stats.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Fancy Cap,Buckler",
        "Skills: Ocean,Tentacle",
        "Passive: Sea Strength",
        "",
      ]],
    303 => # マリンプリンセス / Marine Princess
      [[
        "A Sea-Dweller who exercises dominion over the ocean, using the overwhelming power of her tentacles to destroy her enemies at her leisure. The Marine Princess can learn a variety of Ocean skills and use her tentacles to bind or pleasure enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Fancy Cap,Buckler",
        "Skills: Ocean,Tentacle",
        "Passive: Super Sea Strength",
        "",
      ]],
    304 => # 深海搾精種 / Deep-Sea Leech
      [[
        "A Leech who comes from the ocean depths, possessing a needle she can use to paralyze enemies and even immerse them in ecstasy. The Deep Sea Leech is stronger than most Sea-Dwellers thanks to her talents with Ocean skills, the ability to discharge electricity towards groups of enemies, and her sturdy defense and resistance to pleasure.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Fancy Cap,Buckler",
        "Skills: Ocean,Tentacle",
        "Passive: Sea Strength,Deep Sea Strength",
        "",
      ]],
    305 => # 深淵の主 / Abyss Lord
      [[
        "A Sea-Dweller who rules the abyss of the ocean, capable of using powerful Tentacle skills and unleashing intense Lightning attacks. The Abyss Lord possesses the power to summon a whirlpool and is even capable of immersing enemies in pleasure before devouring them whole.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Fancy Cap,Buckler",
        "Skills: Ocean,Tentacle",
        "Passive: Super Sea Strength,Super Deep Sea Strength",
        "",
      ]],
    306 => # 竜宮舞妓 / Sea Palace Maiko
      [[
        "A Sea-Dweller diva who performs with Dancing and Singing skills learned from the Dragon Palace. The Sea Palace Maiko can utilize powerful Fan skills to summon waves of water to attack enemies; however, her stats are generally low, excluding Dexterity, so front-line combat is highly inadvisable.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Skimpy,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Dancing,Singing,Sexcraft,Ocean,Tentacle",
        "Passive: Eva +10%,Mag Eva +10%,Sea Strength",
        "   Fan Booster 20%",
      ]],
    307 => # 竜宮姫 / Sea Palace Princess
      [[
        "A princess Sea-Dweller who resides in the Dragon Palace, inheriting secret Dancing and Singing skills for use on the battlefield. The Sea Palace Princess also learns mysterious Fan skills handed down from the palace, making her a valuable support character.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Skimpy,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Dancing,Singing,Sexcraft,Ocean,Tentacle",
        "Passive: Eva/Mag Eva +10%,Super Sea Strength",
        "   Fan Booster 20%",
      ]],
    308 => # 海神
      [[ "A legendary great phantom beast that rules the vast seas Possessing the power to fill the world with oceans sealed by the gods Wields tentacles that destroy everything and the power of massive tsunamis that flood continents Also boasts high vitality and DEF capable of handling any situation",
  "",
  "",
  "",
],
[
  "Equip: Breastplate B, Shell A, Robe B, Skimpy B, Magic Hat B, Fancy Cap A, Buckler B, Skill: Dance, Sing, Sexcraft, Ocean, Tentacle, Passive: Penetrate Water Resistance, Tentacle  Ignore DEF, Super Sea Strength, Super Deep Sea Strength, "
]],
    7429 => # 名状しがたきもの
      [[ "An Dark Goddess from another world that flew in from outer space in ancient times Continues to sleep in the deep sea designated as a forbidden species due to its immense power Capable of learning SKL powerful enough to annihilate entire planets Boasts exceptional resistances and versatile strength",
  "",
  "",
  "",
],
[
  "Equip: Breastplate SS, Shell SSS, Robe SS, Skimpy SS, Magic Hat SS, Fancy Cap SSS, Buckler SS, Skill: Dance, Sing, Sexcraft, Ocean, Tentacle, Passive: Penetrate Water Resistance, Tentacle  Ignore DEF, Super Sea Strength, Super Deep Sea Strength, Activates Call of Cthulhu according to enemy status ailments"
]],
    309 => # 妖虫 / Insect
      [[
        "Taut and firm insect girl. Brandishes stingers and scales to attack and weaken enemies. A sturdy carapace provides high defense but little protection against status ailments.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Hat,Fancy Cap",
        "Skills: Insect",
        "Passive: Great Defense,Desert Strength",
        "",
      ]],
    310 => # 闇蟲 / Dark Insect
      [[
        "An Insect possessing a strong exoskeleton, using sickle-like claws and a stinger to assault her foes. Although the Dark Insect has lackluster magic, she has extremely high offensive and defensive power and can generate a powerful Vibration Wave to strike groups of enemies at once.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Hat,Fancy Cap",
        "Skills: Insect",
        "Passive: Ultimate Defense,Desert Strength",
        "",
      ]],
    311 => # 冥蟲 / Underworld Insect
      [[
        "A high-ranking Insect from the underground with a body more powerful than any standard weapon. Armed with her deadly scales and extremely tough armor, the Underworld Insect is both strong and sturdy, despite her weakness to status ailments.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Shell,Hat,Fancy Cap",
        "Skills: Insect",
        "Passive: Ultimate Defense,Super Desert Strength",
        "",
      ]],
    312 => # レギオン / Legion
      [[
        "An Insect that acts and fights in accordance with the will of the colony, not unlike ants or bees. An Insect of the Legion is able to make use of Unarmed skills, call in friends for reinforcements, and even utilize her stinger as a weapon. However, her form closely resembles a human body, so her defense is inferior compared to most other bug monsters.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Hat,Fancy Cap",
        "Skills: Unarmed,Insect",
        "Passive: Desert Strength",
      ]],
    313 => # マザーレギオン / Legion Mother
      [[
        "An Insect who is the established leader of her colony, each one of them capable of many abilities. With knowledge of special Unarmed and Insect skills, including one that can kill enemies instantly with poisonous stingers, the Legion Mother is very successful on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Hat,Fancy Cap",
        "Skills: Unarmed,Insect",
        "Passive: Desert Strength",
        "",
      ]],
    314 => # アラクネ / Arachne
      [[
        "An Insect born from the spider family, possessing high magical power including a gift for Time Magic. The Arachne is not only good with Magic, but her support capability is very high; she can also launch sticky silk from her abdomen for a variety of attacks and restraints.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Dress,Skimpy,Hat,Magic Hat",
        "   Fancy Cap",
        "Skills: Time Magic,Insect",
        "Passive: Mag Eva +10%",
        "",
      ]],
    315 => # アトラク＝ナクア / Atlach-Nacha
      [[
        "A high-grade Arachne, using her tremendous Magic to warp time and dominate space from the past straight into the future. The Atlach-Nacha also possesses destructive physical power, and with the addition of learning predation skills, her skill diversity is exceptional.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Robe,Dress,Skimpy,Hat,Magic Hat",
        "   Fancy Cap",
        "Skills: Time Magic,Insect",
        "Passive: Mag Eva +10%",
        "",
      ]],
    317 => # クィーンインセクト / Queen Insect
      [[
        "An Insect who reigns over all types of her race; the Queen Insect shows that she is worthy of her title due to her very strong exoskeleton that can repel many attacks and using of her body, sickle-like claws, arms, and vibrating organs to boast high combat ability.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Breastplate,Shell,Robe,Dress,Skimpy,Hat",
        "   Magic Hat,Fancy Cap",
        "Skills: Unarmed,Time Magic,Insect",
        "Passive: Ultimate Defense,Super Desert Strength",
        "",
      ]],
    318 => # 神蟲
      [[ "A great demon insect worshipped as a god in desert regions Designated as a sealed species by the gods for disrupting the balance of nature Boasts extremely high DEF with exceptional attribute and status ailment resistances The insect SKL that can be learned are also powerful boasting overwhelming strength",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes C, Gi C, Breastplate B, Shell A, Robe C, Dress C, Skimpy C, Hat A, Magic Hat C, Fancy Cap A, Skill: Unarmed, Time Magic, Insect, Passive: Ultimate Defense, Super Desert Strength, Counter Damage +2 Levels"
]],
    7430 => # バアル・ゼブル
      [[ "A forbidden phantom insect said to reign in the high skies Through collective consciousness it seeks to integrate with the world itself Learns multiple powerful SKL that invite all things into the hive mind Also boasts exceptional defensive performance with extremely high survivability",
  "",
  "",
  "",
],
[
  "Equip: Clothes S, Gi S, Breastplate SS, Shell SSS, Robe S, Dress S, Skimpy S, Hat SSS, Magic Hat S, Fancy Cap SSS, Skill: Unarmed, Time Magic, Insect, Passive: Super Ultimate Defense, Super Desert Strength, Counter Damage +4 Levels, Perfect Counter"
]],
    319 => # アルラウネ / Alraune
      [[
        "Gently seductive flower monsters with healing power. Using things like ivy and pollen, Alraunes use their bodies offensively. They are also skilled with whips and learn basic whip skills, but are best suited using their nectar in a healing role for the party.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Robe,Hat,Magic Hat,Fancy Cap,Buckler",
        "Skills: Whip,White Magic,Plant",
        "Passive: Medicine Lore I,Whip Booster 20%,Poison Strike +5%",
        "   Confusion/Paralysis Strike +5%",
        "",
      ]],
    320 => # ハイアルラウネ / High Alraune
      [[
        "A kind Alraune who is able to use White Magic and her nectar to heal her allies. Although she is capable of using her ivy as weapons to strike and restrain enemies, the High Alraune is well suited in a support role as she is not a strong physical fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Robe,Hat,Magic Hat,Fancy Cap,Buckler",
        "Skills: Whip,White Magic,Plant",
        "Passive: Medicine Lore II,Whip Booster 20%,Recovery Booster 50%",
        "   Poison/Confusion/Paralysis Strike +5%",
        "",
      ]],
    321 => # 慈愛の聖花 / Alraune Saint
      [[
        "A high-ranking Alraune with a spirit of compassion, possessing exceptional power and talent with her ivy and Whip skills. With her incredible healing powers and honey that can even revive the dead, the Alraune Saint is a very reliable support companion.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Robe,Hat,Magic Hat,Fancy Cap,Buckler",
        "Skills: Whip,White Magic,Plant",
        "Passive: Medicine Lore III,Whip Booster 20%",
        "   Recovery Booster 50%,Poison/Confusion/Paralysis Strike +5%",
        "",
      ]],
    322 => # ワルラウネ / Walraune
      [[
        "A bad Alraune with a dark heart that drains the energy from her enemies and impairs them with her crippling pollen. With knowledge of powerful Whip skills to bring harm to her foes, the Walraune is more suited for direct combat when compared to others of her species.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Robe,Hat,Magic Hat,Fancy Cap,Buckler",
        "Skills: Whip,Black Magic,Plant",
        "Passive: Whip Booster 20%,Plant Ailment Booster 50%",
        "   Poison/Confusion/Paralysis Strike +7%",
        "",
      ]],
    323 => # 彼岸の魔花 / Flower of Nirvana
      [[
        "A jet-black Alraune with a destructive will and pollen that invite enemies to death. The Flower of Nirvana learns powerful Whip Skills and merciless Plant Skills, sowing chaos on the battlefield by spreading status ailments amongst her enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Robe,Hat,Magic Hat,Fancy Cap,Buckler",
        "Skills: Whip,Black Magic,Plant",
        "Passive: Whip Booster 20%,Plant Ailment Booster 50%",
        "   Poison/Confusion/Paralysis Strike +10%",
        "",
      ]],
    324 => # 食虫淫花 / Carnivorous Flower
      [[
        "A species of Alraune with a hunger for melting and devouring prey of all kinds. The Carnivorous Flower can learn special whip skills to digest her restrained foes and with her high attack power, she can fight in direct combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Robe,Hat,Magic Hat,Fancy Cap,Buckler",
        "Skills: Whip,Slime,Plant",
        "Passive: Whip Booster 20%,Digest/Trance Strike +10%",
        "",
      ]],
    325 => # ビーナスネペンテス / Venus Nependeath
      [[
        "A carnivorous Alraune who has feasted upon countless creatures. With Whip skills to melt enemies, techniques that allow her to devour groups of enemies at once, and a good balance of stats, the Venus Nependeath is a mighty creature.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Whip,Gi,Breastplate,Robe,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Whip,Slime,Plant",
        "Passive: Whip Booster 20%,Digest/Trance Strike +15%",
        "",
      ]],
    326 => # クィーンアルラウネ / Queen Alraune
      [[
        "An Alraune who stands at the top of the chain of command. With her mastery and control of Whip, Plant, Slime, and ultimately White and Black Magic skills, the Queen Alraune is an almighty force with both offensive and recovery power.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Gi,Breastplate,Robe,Hat,Magic Hat,Fancy Cap,Buckler",
        "Skills: Whip,White Magic,Black Magic,Slime,Plant",
        "Passive: Ultimate Medicine,Whip Booster 20%",
        "   Recovery Booster 50%,Plant Ailment Booster 50%",
        "   Poison/Confusion/Paralysis/Digest/Trance Strike +15%",
      ]],
    327 => # 世界樹花
      [[ "A legendary magical flower with the will of the majestic World Tree Designated as a sealed species for absorbing the lives of many angels during the Great Monster Wars Excels in healing power and possesses extremely high magic Boasts unparalleled performance as a support despite its fragile defense",
  "",
  "",
  "",
  "",
],
[
  "Equip: Gi C, Breastplate B, Robe A, Hat B, Magic Hat A, Fancy Cap A, Buckler B, Skill: Whip, White Magic, Black Magic, Slime, Plant, Passive: Normal Attack Poison 20%, Normal Attack Confusion 20%, Normal Attack Paralysis 20%, Ultimate Medicinal Effect, Increase Whip Power 30%, Increase Plant  Status Ailment Rate"
]],
    7431 => # 千樹華音
      [[ "The ultimate magical tree that grows by absorbing the essence of the stars Designated as a forbidden species for blooming flowers in exchange for the life of the earth Its vines cover the ground and its pollen is said to bring about the apocalypse Also learns the ultimate secret art of whip SKL demonstrating immense power",
  "",
  "",
  "",
  "",
],
[
  "Equip: Gi S, Breastplate SS, Robe SSS, Hat SS, Magic Hat SSS, Fancy Cap SSS, Buckler SS, Skill: Whip, White Magic, Black Magic, Slime, Plant, Passive: Normal Attack Poison/Confusion/Paralysis 30%, Ultimate Medicinal Effect, Increase Whip Power 30%, Increase Plant Status Ailment Rate, Applies full recovery and healing plant to reserve allies"
]],
    328 => # ゾンビ / Zombie
      [[
        "Shambling corpse reanimated by unknown means. With no memory or sense of self to speak of, its stats amount to little else but endurance and brute force. Preferably with a club.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Heavy Armor,Hat,Helmet",
        "   Heavy Helmet",
        "Skills: Club,Dancing,Corpse,Breath",
        "Passive: Poison/Zombie Strike +5%",
        "",
      ]],
    329 => # ハイアンデッド / High Undead
      [[
        "An undead creature who has grown stronger, using brute force to compensate for intelligence. Although the High Undead can produce toxins to supplement her high offensive power, she is weak at all aspects of magic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Heavy Armor,Hat,Helmet",
        "   Heavy Helmet",
        "Skills: Club,Dancing,Corpse,Breath",
        "Passive: Poison/Zombie Strike +10%",
        "",
      ]],
    330 => # マスターアンデッド / Master Undead
      [[
        "A high-grade undead who has immense spiritual energy, well suited for crushing her enemies to a pulp in spite of her low intelligence. The Master Undead possesses extreme physical strength and can learn powerful attacks that can poison and zombify enemies; however, her magic is still nothing of value.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Heavy Armor,Hat,Helmet",
        "   Heavy Helmet",
        "Skills: Club,Dancing,Corpse,Breath",
        "Passive: Poison/Zombie Strike +15%",
        "",
      ]],
    331 => # マミー / Mummy
      [[
        "A special type of undead revived through the use of cursed bandages, surpassing other Zombies with her ability to invoke powerful spells. The Mummy can use her bandage wraps to capture and restrain her enemies, and with her high magical power, she is well suited for the role of magician.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Robe,Hat,Helmet,Magic Hat",
        "Skills: Club,Black Magic,Demon Arts,Corpse",
        "Passive: Mag Eva +10%,Mini/Petrify Strike +5%",
        "",
      ]],
    332 => # イシス / Isis
      [[
        "A high-ranking Mummy with advanced magic, utilizing powerful spells to destroy entire groups of enemies. In addition to being a capable magical fighter, an Isis can also use her bandages to bind her enemies and drain them dry.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Robe,Hat,Helmet,Magic Hat",
        "Skills: Club,Black Magic,Demon Arts,Corpse",
        "Passive: Mag Eva +10%,Mini/Petrify Strike +10%",
        "",
      ]],
    333 => # ゾンビドクター / Zombie Doctor
      [[
        "An insane Doctor who has been resurrected as an undead creature, spreading poison and other biological contamination through her Medicine skills. Although her stats are not particularly high, the Zombie Doctor can inject enemies with a virus to zombify them, making her suitable for a supportive role.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Robe,Hat,Helmet,Magic Hat",
        "Skills: Magic Science,Alchemy,Medicine,Corpse",
        "Passive: Poison/Zombie Strike +15%",
        "",
      ]],
    334 => # デスプロフェッサー / Death Professor
      [[
        "A resurrected mad scientist who has accumulated vast knowledge of the magic arts. Armed with powerful Magic Science skills that can create a Biohazard, the Death Professor is an excellent attack force.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Robe,Hat,Helmet,Magic Hat",
        "Skills: Magic Science,Alchemy,Medicine,Corpse",
        "Passive: Poison/Zombie Strike +20%",
        "",
      ]],
    335 => # カオスアンデッド
      [[ "The king of the underworld that brings death and apocalypse to all lands Despised for the power to bring death to the surface designated as a sealed species by the gods Learns the ultimate secret art of club SKL destroying the very earth itself Status ailment effects are also powerful bringing death to all enemies",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes A, Breastplate A, Armor B, Heavy Armor C, Robe C, Hat A, Helmet B, Heavy Helmet C, Magic Hat C, Skill: Club, Black Magic, Dance, Magi-Science, Alchemy, Medicine, Demon Arts, Corpse, Breath, Passive: Normal Attack Poison 20%, Normal Attack Mini 20%, Normal Attack Zombie 20%, Normal Attack Petrify 20%, Club /Medicine/Corpse  Sturdy Activation"
]],
    7432 => # ノーライフキング
      [[ "An immortal anti-life entity that denies the laws of the world Remains in the present world by exploiting bugs in the laws of physics Therefore they automatically revive at the end of each turn even if incapacitated Their vitality and ATK are extremely high demonstrating power in melee combat",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Breastplate SSS, Armor SS, Heavy Armor S, Robe S, Hat SSS, Helmet SS, Heavy Helmet S, Magic Hat S, Skill: Club, Black Magic, Dance, Magi-Science, Alchemy, Medicine, Demon Arts, Corpse, Breath, Passive: Normal Attack Poison 30%, Normal Attack Mini 30%, Normal Attack Zombie 30%, Normal Attack Petrify 30%, Club /Medicine/Corpse  Sturdy Activation, Immortal Body"
]],
    336 => # ゴースト / Ghost
      [[
        "Ethereal being made of dark magic and souls. These undead creatures are masters of haunted flames. Deadly with scythes and strong against physical attacks, but poor against magic.",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Magic Hat",
        "Skills: Scythe,Black Magic,Corpse",
        "Passive: Eva +30%,Scythe Booster 20%,Mag Ref +10%",
        "   Death Strike +5%",
        "",
      ]],
    337 => # エビルミスト / Evil Mist
      [[
        "A Ghost who has grown stronger through accumulating high concentrations of dark magic. The Evil Mist is capable of burning enemies with Black Magic, learning greater Scythe skills, and even using pleasure attacks to drain the health of entire groups of enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Magic Hat",
        "Skills: Scythe,Black Magic,Corpse",
        "Passive: Eva +30%,Scythe Booster 20%,Mag Ref +30%",
        "   Death Strike +10%",
        "",
      ]],
    338 => # マスターシャドウ / Master Shadow
      [[
        "A top-ranked Ghost who has accumulated vast amounts of dark energy. With Scythe skills that bring death to enemies and the power to burn away everything with the fires of Hell, the Master Shadow plays an active role as a magic fighter.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Magic Hat",
        "Skills: Scythe,Black Magic,Corpse",
        "Passive: Eva +30%,Scythe Booster 20%,Mag Ref +50%",
        "   Death Strike +20%",
        "",
      ]],
    339 => # 魔棲の書物 / Grimoire
      [[
        "A subspecies of Ghost spiritually bound to a book. By wielding powerful Grimoire skills, including the ability to create pages for further use, she is a versatile magical fighter, even though her defense is higher and magic defense is lower than most magicians.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Magic Hat",
        "Skills: Alchemy,Grimoire,Corpse",
        "Passive: Eva +20%",
        "",
      ]],
    340 => # ページオブロード / Page Lord
      [[
        "A Grimoire with high spirituality, boasting magic power accumulated over hundreds of years. The Page Lord can master powerful Grimoire skills, each one activating a variety of effects; however, her magic defense is quite low, so caution is advisable.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Magic Hat",
        "Skills: Alchemy,Grimoire,Corpse",
        "Passive: Eva +20%",
        "",
      ]],
    341 => # ミミック / Mimic
      [[
        "A treasure chest possessed by a ghost who attacks with fangs and slime. The Mimic can swallow digested enemies whole and has high defense in comparison to other Ghost-type monsters.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Magic Hat",
        "Skills: Black Magic,Slime,Corpse",
        "Passive: Battle Start Surprise Box 100%,Cave Strength",
        "   Death Strike +20%",
        "",
      ]],
    342 => # パンドラ / Pandora
      [[
        "A powerful Mimic who has mastered the cruel art of predation. With additional capabilities of biting foes with her fangs, bringing Mass Death to groups of enemies, and a good balance of stats, Pandora can handle any variety of combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Robe,Magic Hat",
        "Skills: Black Magic,Slime,Corpse",
        "Passive: Battle Start Surprise Box 100%",
        "   Super Cave Strength,Death Strike +30%",
        "",
      ]],
    343 => # エターニティ
      [[ "A legendary ghost said to exist forever Designated as a sealed species for burying countless angels during the Great Monster Wars Capable of learning powerful SKL and abilities that connect to death Weak to attribute attacks but highly likely to reflect magic",
  "",
  "",
  "",
],
[
  "Equip: Robe A, Hat A, Magic Hat A, Buckler C, Shield C, Skill: Scythe, Black Magic, Dark, Alchemy, Grimoire Arts, Slime, Corpse, Passive: Normal Attack Instant Death 50%, Magic Reflect 75%, Increase Scythe Power 30%, Cave Super Enhancement: Darkness Skill Power +50%"
]],
    7433 => # 死神
      [[ "The ruler reigning over the underworld overseeing the death of all things Despised for their power that even gods cannot reach designated as a forbidden species Capable of learning the ultimate secret art of scythe SKL and powerful flame arts Possesses a powerful ability that reflects all magic",
  "",
  "",
  "",
],
[
  "Equip: Robe SSS, Hat SSS, Magic Hat SSS, Buckler S, Shield S, Skill: Scythe, Black Magic, Dark, Alchemy, Grimoire Arts, Slime, Corpse, Passive: Normal Attack Instant Death 100%, Complete Magic Reflect, Increase Scythe Power 30%, Corpse  Sturdy Activation, Super Cave Strength, Maximize Dark Technique Power"
]],
    344 => # ドール / Doll
      [[
        "Basic construct with free will. Fights with weapons implanted within its body. In accordance with the Laws of Robotics, it gladly serves others and learns as it goes. Its artificial body blocks most ailments.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Robe,Dress,Skimpy,Hat,Fancy Cap,Buckler",
        "Skills: Service,Demon Arts,Artificial",
        "Passive: None",
        "",
      ]],
    345 => # エビルマータ / Evilmaton
      [[
        "A Doll monster that has become stronger through spiritual powers, using her many body parts as weapons. Although her stats are not very high, the Evilmaton can learn a variety of useful skills, including the ability to use her hair to drain energy from her enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Robe,Dress,Skimpy,Hat,Fancy Cap,Buckler",
        "Skills: Service,Demon Arts,Artificial",
        "Passive: None",
        "",
      ]],
    346 => # フォースドール / Force Doll
      [[
        "A high-ranking Doll monster with extreme spiritual power, armed with many weapons and the ability to self-destruct. The Force Doll is capable of using powerful Service skills to pleasure their foes, and possesses immunity to multiple status ailments.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Robe,Dress,Skimpy,Hat,Fancy Cap,Buckler",
        "Skills: Service,Demon Arts,Artificial",
        "Passive: None",
        "",
      ]],
    347 => # ボーカロイド / Vocaloid
      [[
        "A Doll made for entertainment, singing a variety of songs that can impair enemies with different status ailments. The Vocaloid is also able to use sound as a weapon to damage her enemies, making her excellent in a support role despite being unsuited for melee combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Robe,Dress,Skimpy,Hat,Fancy Cap",
        "Skills: Singing,Service,Artificial",
        "Passive: Eva/Mag Eva +10%",
        "",
      ]],
    348 => # アカデミードール / Academy Doll
      [[
        "A high-ranked Vocaloid created to use unmatched Dancing and Singing skills, each with many special effects. The Academy Doll learns skills that can be used for both support and offense, making her a highly versatile and reliable contribution on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Robe,Dress,Skimpy,Hat,Fancy Cap",
        "Skills: Dancing,Singing,Service,Artificial",
        "Passive: Eva/Mag Eva +10%",
        "",
      ]],
    349 => # ゴーレム / Golem
      [[
        "A large artificial monster created with metal and stone through the art of Magic Science. The Golem possesses colossal strength and learns many physical attack skills that make use of her tremendous bulk and her overwhelming power.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Heavy Armor,Helmet,Fancy Cap",
        "Skills: Artificial,Giant",
        "Passive: Endure",
        "",
      ]],
    350 => # マスターゴーレム / Master Golem
      [[
        "A Golem who has been reinforced with magic, granting her even more overwhelming power. With her knowledge of multiple powerful physical skills and her extremely high defense, the Master Golem is well built for melee combat.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Heavy Armor,Helmet,Fancy Cap",
        "Skills: Artificial",
        "Passive: Super Endure",
        "",
      ]],
    353 => # 究極至高人形
      [[ "The ultimate and supreme doll created with unknown technology Deployed during the Great Monster Wars and treated as a sealed species after the war Can learn various SKL befitting the ultimate doll Also possesses a glimpse of chaotic power and has resistance to chaos damage",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes A, Breastplate C, Shell C, Robe B, Dress A, Skimpy A, Hat A, Fancy Cap A, Helmet C, Buckler B, Shield B, Skill: Gun, Dance, Sing, Makina, Service, Demon Arts, Artificial, Passive: Ultimate Endure, Chaos Attribute Reduction"
]],
    7434 => # Kagetsumugi, The Doll 影、紬ぐ人形
      [[ "A forbidden doll perfected by a genius puppeteer who dabbled in forbidden arts Boasts unprecedented strength due to technology beyond human understanding Learns extremely dangerous SKL unknown dances and songs Slightly increased resistance to chaos attributes",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Breastplate S, Shell S, Robe SS, Dress SSS, Skimpy SSS, Hat SSS, Fancy Cap SSS, Helmet S, Buckler SS, Shield SS, Skill: Gun, Dance, Sing, Makina, Service, Demon Arts, Artificial, Passive: Ultimate Endure, Chaos Attribute Reduction"
]],
    354 => # キメラ / Chimera
      [[
        "Artificial monster made by state-of-the-art biotechnology. Amalgamation of superior parts grants it superb fighting power. Can breathe fire, ice, and even lightning. Comes with basic self-repair systems and fantastic vitality.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Skimpy,Hat,Helmet,Buckler,Shield",
        "Skills: Beast,Artificial,Breath",
        "Passive: None",
        "",
      ]],
    355 => # 三種混合体 / Tri-Chimera
      [[
        "A Chimera formed from many strong monsters, with a selectively modified body and potent Breath attacks. With the ability to capture and assimilate foes into her form and her high stats, the Tri-Chimera will play a useful role in many situations.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Skimpy,Hat,Helmet,Buckler,Shield",
        "Skills: Beast,Artificial,Breath",
        "Passive: None",
        "",
      ]],
    356 => # ギガミュータント / Giga Mutant
      [[
        "A supreme Chimera said to be completely perfect, boasting overwhelming combat capabilities. Although her magic power is somewhat low, the Giga Mutant has extraordinary stats and a Breath skill that harnesses the element of Darkness, making her very reliable.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Skimpy,Hat,Helmet,Buckler,Shield",
        "Skills: Beast,Artificial,Breath",
        "Passive: None",
        "",
      ]],
    357 => # 魔導キメラ / Magical Chimera
      [[
        "A Chimera made with Yoma genes, granting her magical capabilities. The Magical Chimera can also perform Summoning skills, and with physical stats on par with her magical powers, she can handle fighting on the front lines.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Skimpy,Hat,Helmet,Magic Hat",
        "   Buckler,Shield",
        "Skills: White Magic,Black Magic,Summoning,Demon Arts,Artificial",
        "   Breath",
        "Passive: None",
      ]],
    358 => # フォースミュータント / Force Mutant
      [[
        "A Magical Chimera who has attained greater magical might, expressing power much like a living furnace. The Force Mutant is capable of creating a forcefield, unleashing a Breath skill empowered by the Holy element, and ultimately Summoning artificial versions of the Four Spirits.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Robe,Skimpy,Hat,Helmet,Magic Hat",
        "   Buckler,Shield",
        "Skills: White Magic,Black Magic,Summoning,Demon Arts,Artificial",
        "   Breath",
        "Passive: None",
      ]],
    359 => # キメラロイド / Chimeraroid
      [[
        "A Chimera created with both biological and mechanical parts, including weapons capable of destroying enemies with overwhelming firepower. Although her Speed and Magic are lackluster, the Chimeraroid possesses superior Attack and Defense, as well as the ability to repair her body, making her extremely effective in combat.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Skimpy,Hat,Helmet,Buckler,Shield",
        "Skills: Gun,Makina,Artificial",
        "Passive: None",
      ]],
    360 => # 機神 / Machine God
      [[
        "The supreme mechanical Chimera made with cutting edge technology, including weapons that are capable of bringing endless destruction. With her versatile control over guns, as well as her high stats and formidable resistance against status ailments, the Machine God spares no enemy on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Skimpy,Hat,Helmet,Buckler,Shield",
        "Skills: Gun,Makina,Artificial",
        "Passive: None",
        "",
      ]],
    361 => # ウェポンタイプ
      [[ "A super bio-weapon manufactured during the Great Monster Wars Operates on the conflicting energy reactions of darkness and light Its power is extremely immense demonstrating unparalleled strength Learns multiple powerful attack SKL boasting invincible power",
  "",
  "",
  "",
],
[
  "Equip: Breastplate A, Shell A, Skimpy B, Hat B, Helmet A, Buckler B, Shield B, Skill: Gun, White Magic, Black Magic, Makina, Demon Arts, Beast, Artificial, Breath, Passive: Halved MP and SP Consumption for 6 Turns After Battle Start"
]],
    7435 => # オメガタイプ
      [[ "The ultimate weapon type completed with divine technology Possesses inexhaustible power capable of reducing civilizations to ashes The SKL learned are extremely powerful befitting the name of the ultimate weapon Additionally there is no consumption of MP or SP at the start of battle allowing for rampant destruction",
  "",
  "",
  "",
  "",
],
[
  "Equip: Breastplate SSS, Shell SSS, Skimpy SS, Hat SS, Helmet SSS, Buckler SS, Shield SS, Skill: Gun, White Magic, Black Magic, Makina, Demon Arts, Beast, Artificial, Breath, Passive: Zero MP and SP Consumption for 4 Turns After Battle Start"
]],
    362 => # 下位天使 / Lowly Angel
      [[
        "The vanguard in the armies of Heaven. Their holy power can be used for both attacking and healing. Skilled with swords and holy techniques. Balanced stats and excellent resistances.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Magic Hat,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Rapier,White Magic,Holy",
        "Passive: Eva/Mag Eva +10%,Body of Divine Protection",
        "",
      ]],
    363 => # 中位天使 / Mid-Ranking Angel
      [[
        "An Angel from the middle ranks who rarely visits the Earth, wielding divine power granted to her from the Goddess Ilias. With knowledge of powerful Sword skills coupled with her superior attack and recovery abilities, the Mid-Ranking Angel is clearly a great contribution on the battlefield.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Magic Hat,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Rapier,White Magic,Holy",
        "Passive: Eva/Mag Eva +10%,Body of Grace",
        "",
      ]],
    364 => # 上位天使 / High Angel
      [[
        "An Angel recognized by the Goddess Ilias and placed among the highest ranks. With powerful Sword skills that execute divine justice, the ability to perform heavenly miracles, and even her high stats, the High Angel shows versatility in any situation.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Magic Hat,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Rapier,White Magic,Holy",
        "Passive: Eva/Mag Eva +10%,Body of Miracles",
        "",
      ]],
    365 => # 堕天使 / Fallen Angel
      [[
        "A High Angel who rebelled against the Goddess Ilias and fell to the Earth, retaining her power despite falling. The Fallen Angel can learn many offensive skills and wield them with her blade; with high combat capabilities and the ability to heal through Meditation, she is a force to be reckoned with.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Magic Hat,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Rapier,Black Magic,Holy,Dark",
        "Passive: Eva/Mag Eva +10%,Body of Miracles",
        "",
      ]],
    366 => # ヴァルキリー / Valkyrie
      [[
        "A war Angel given the role of destroying Ilias' enemies. The Valkyrie can wield powerful Spear skills, charge stamina by consuming mana, and naturally utilize Holy abilities used to destroy evil.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Magic Hat,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Rapier,Spear,Holy,Spellblade",
        "Passive: Eva/Mag Eva +10%,Body of Grace",
        "",
      ]],
    367 => # ロードヴァルキリア / Valkyrie Lord
      [[
        "A Valkyrie who leads allies as the pinnacle of heroism. Wielding powerful spear skills, including one that can restore stamina for repeated use, as well as the ability to attack multiple enemies at once. The Valkyrie Lord boasts unrivaled strength capable of destroying all of the Goddess' enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Armor,Heavy Armor,Robe,Dress,Skimpy,Hat,Helmet",
        "   Heavy Helmet,Magic Hat,Fancy Cap,Buckler,Shield,Heavy Shield",
        "Skills: Dagger,Sword,Rapier,Spear,Holy,Spellblade",
        "Passive: Eva/Mag Eva +10%,Body of Miracles",
        "",
      ]],
    368 => # キューピッド / Cupid
      [[
        "An Angel of love who controls the emotions and desire of mortal creatures. The Cupid can use her Bow skills to disturb an enemy's heart or smite them with Holy power, as well as learn powerful healing spells.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Bow,White Magic,Black Magic,Holy,Sexcraft",
        "Passive: Eva/Mag Eva +30%,Body of Grace",
        "   Seduction Strike 20%",
      ]],
    369 => # 淫欲のクピド / Cupid of Lust
      [[
        "A high-ranking Cupid with very high Holy energy. With the acquisition of many offensive attacks, including Bow abilities blessed with divine power, healing spells, and a variety of Sexcraft skills, the Cupid of Lust is extremely versatile.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Gi,Robe,Dress,Skimpy,Hat,Magic Hat,Fancy Cap",
        "   Buckler",
        "Skills: Bow,White Magic,Black Magic,Holy,Sexcraft",
        "Passive: Eva/Mag Eva +30%,Body of Miracles",
        "   Seduction Strike +40%",
        "",
      ]],
    370 => # 熾天使
      [[ "The highest-ranking angel among high-ranking angels a top executive class Designated as a sealed species because only those chosen by the Goddess herself are given this position Their offensive capabilities are immense capable of annihilating divine enemies with overwhelming power While weak to pleasure they boast universal resistance to everything else",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes B, Gi B, Armor A, Heavy Armor A, Robe A, Dress A, Skimpy B, Hat B, Helmet A, Heavy Helmet A, Magic Hat A, Fancy Cap A, Buckler A, Shield A, Heavy Shield A, Skill: Dagger, Sword, Rapier, White Magic, Time Magic, Holy, Passive: Holy Skill Power +50% Ancient Body"
]],
    7436 => # 天の軍団長
      [[ "The highest-ranking angel standing at the pinnacle of all angels Entrusted with the heavenly military power by the God leading the army of angels Capable of learning the ultimate sword technique called the Sword of the Heavenly Army Also manipulates holy power annihilating divine enemies",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Armor SSS, Heavy Armor SSS, Robe S, Dress SS, Skimpy SS, Hat SS, Helmet SSS, Heavy Helmet SSS, Magic Hat S, Fancy Cap SS, Buckler SSS, Shield SSS, Heavy Shield SSS, Skill: Dagger, Sword, Rapier, White Magic, Time Magic, Holy, Passive: Maximize Holy Technique Power, Body of the Gods, Physical Reflect"
]],
    7437 => # 明けの明星
      [[ "The highest-ranking angel who fell and rebelled against the God Said to be the strongest fallen angel returning the world to ruin Capable of using the secret art Morning Star named after themselves Her archery skills are astounding said to be unmatched in heaven and earth.",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Armor SS, Heavy Armor SS, Robe SSS, Dress SSS, Skimpy SSS, Hat SS, Helmet SS, Heavy Helmet SS, Magic Hat SSS, Fancy Cap SSS, Buckler SSS, Shield SSS, Heavy Shield SSS, Skill: Bow, White Magic, Black Magic, Time Magic, Holy, Dark, Passive: Maximize Holy and Dark Technique Power, Body of the Gods, Magic Reflect"
]],
    7438 => # 慈愛の聖百合
      [[ "One of the Seven Great Angels newly created by the Goddess Known as the Holy Lily of Compassion and Judgment Masters healing power capable of activating Holy and healing SKL simultaneously Also freely manipulates plants using them as extensions of their own body",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Armor S, Heavy Armor S, Robe SSS, Dress SSS, Skimpy SSS, Hat SS, Helmet S, Heavy Helmet S, Magic Hat SSS, Fancy Cap SSS, Buckler SS, Skill: Whip, White Magic, Holy, Plant, Passive: Maximize Holy Technique Power, Body of the Gods, Activates Gabrielas Great Blessing at the Start of Battle"
]],
    7439 => # 律法の守護者
      [[ "One of the Seven Great Angels newly created by the Goddess Said to guard the law and have mastered magic from all ages and places When using Holy SKL capable of protecting all allies Despite their pure appearance they are said to have a lewd nature",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Armor S, Heavy Armor S, Robe SSS, Dress SSS, Skimpy SSS, Hat SS, Helmet S, Heavy Helmet S, Magic Hat SSS, Fancy Cap SSS, Buckler SS, Skill: White Magic, Black Magic, Time Magic, Holy, Grimoire Arts, Sexcraft, Passive: Maximize Holy Technique Power, Body of the Gods, Activates Saints Protection after Holy"
]],
    7440 => # 天界決戦兵器
      [[ "One of the Seven Great Angels newly created by the Goddess Presides over destruction and wrath said to command the flames of the gods Their power is immense said to have destructive weapons embedded throughout their body When using Holy SKL simultaneously fires multiple missiles",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Armor SSS, Heavy Armor SSS, Robe S, Dress S, Skimpy S, Hat SS, Helmet SSS, Heavy Helmet SSS, Magic Hat S, Fancy Cap S, Buckler SS, Shield SS, Heavy Shield SS, Skill: Unarmed, Holy, Makina, Artificial, Passive: Maximize Holy Technique Power, Body of the Gods, Activates Mighty Missile after Holy"
]],
    7441 => # 死の契約者
      [[ "One of the Seven Great Angels newly created by the Goddess An angel of forbidden arts who presides over death also said to be a fallen angel Despite being an angel they master the power of darkness and bring great calamities Revives every turn and never perishes",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Armor S, Heavy Armor S, Robe SS, Dress SSS, Skimpy SSS, Hat SS, Helmet S, Heavy Helmet S, Magic Hat SS, Fancy Cap SSS, Buckler SS, Shield SS, Skill: Scythe, Black Magic, Time Magic, Holy, Dark, Demon Arts, Corpse, Passive: Maximize Holy and Dark Technique Power, Body of the Gods, Dark Attribute  HP Consumption 1/4, Immortal Body"
]],
    7442 => # 核動力天使
      [[ "Twin of the Seven Great Angels newly created by the Goddess Excels in shooting weapons such as bows and guns boasting unparalleled rapid-fire and sniping performance Additionally for 5 turns after the start of battle powerful SKL can be repeatedly used without SP consumption However after 5 turns various performances significantly decrease due to cooling",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Armor S, Heavy Armor S, Robe S, Dress SS, Skimpy SSS, Hat SS, Helmet S, Heavy Helmet S, Magic Hat S, Fancy Cap SSS, Buckler S, Shield S, Heavy Shield S, Skill: Bow, Gun, White Magic, Black Magic, Holy, Makina, Artificial, Passive: Maximize Holy Technique Power, Body of the Gods, Nuclear Power, All  SP High Burst"
]],
    7401 => # 試作ロイド / Prototype Roid
      [[
        "An experimental fighting machine. Highly dexterous and skilled in handling firearms and heavy weapons. They are also capable of using a variety of armaments built into their body. Sturdy with high defensive capabilities, but completely unsuited to the use of magic.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Skimpy,Hat,Helmet,Buckler,Shield,Guns",
        "Skills: Gun,Makina,Artificial",
        "Passive: Titanium Armor",
      ]],
    7402 => # サイボーグ / Cyborg
      [[
        "A cyborg that incorporates mechanical parts into the human body. They are skilled in the use of firearms and heavy weapons, and have extremely high agility. They also have a built-in accelerator that allows them to move at super speed. Also has high defensive capabilities, but very low magic power.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Skimpy,Hat,Helmet,Buckler,",
        "　　　Shield,Guns",
        "Skills: Gun,Makina,Artificial",
        "Passive: Accelerator",
      ]],
    7403 => # ナノアンドロイド / Nano Android
      [[
        "An android built with cutting-edge nano-technology. Can temporarily quantize their body to nullify all attacks. Also has the ability to increase the power of firearms and Makina with increased speed. Has excellent defensive capabilities, and their overall combat ability is extremely high.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Armor,Skimpy,Hat,Helmet,Buckler,",
        "　　　Shield,Guns",
        "Skills: Gun,Makina,Artificial",
        "Passive: Quantization,Accelerated Fire,Gun Mastery",
      ]],
    7404 => # 射撃型ロイド / Gunner Roid
      [[
        "A fighting machine who specializes in long-range shooting and artillery. The destructive capacity of their guns and Makina is extremely high, but their defense is low. A slow and sluggish machine only good at shooting. Also has a multi lock-on function, which makes them effective against multiple enemies.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Hat,Gun",
        "Skills: Gun,Makina,Artificial",
        "Passive: Dual Wield,Support Bit,Multi Lock-On",
      ]],
    7405 => # バスターロイド / Buster Roid
      [[
        "A top-class fighting machine with extreme shooting capabilities. Extremely dexterous and skilled in the use of guns and Makina. Has an improved lock-on function and shows their true potential in battle against groups. Their low defensive performance and speed require careful handling.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Shell,Hat,Gun",
        "Skills: Gun,Makina,Artificial",
        "Passive: Dual Wield,Buster Bit,Full Lock-On",
      ]],
    7406 => # 近接型ロイド / Melee Roid
      [[
        "A fighting machine specialized in close combat. Good at close combat against enemies with excellent offensive performance. Very good at defense, and can learn unique defensive abilities. Excels in offense and defense, and has no notable weaknesses other than their inferior magical abilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Armor,Heavy Armor,Shell,Skimpy,Hat,Helmet,",
        "　　　Heavy Helmet,Sword",
        "Skills: Sword,Makina,Artificial",
        "Passive: Dual Wield,CIWS,Assist Vulcan",
      ]],
    7407 => # アサルトロイド / Assault Roid
      [[
        "A high-class combat machine with extreme close quarters combat capabilities. Has extremely high offensive and defensive capabilities, making them an unparalleled force in combat. Has the ability to boost the power of Guns and Makina. Their unique defensive abilities are also useful, providing them with a wide array of abilities.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Breastplate,Armor,Heavy Armor,Shell,Skimpy,Hat,Helmet,",
        "　　　Heavy Helmet,Sword",
        "Skills: Sword,Makina,Artificial",
        "Passive: Dual Wield,Advanced CIWS,Assist Burst,Assault System",
      ]],
    7443 => # アサルトバスター
      [[ "A humanoid weapon that combines the advantages of Assault Roid and Buster Roid Its performance is immense and it has been sealed by the gods Equipped with immense attack capabilities it is capable of both long-range and close-range combat Additionally its abundant unique abilities allow it to demonstrate overwhelming combat power",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes B, Chestplate C, Shell C, Armor A, Heavy Armor A, Light Clothing B, Hat B, Helmet A, Heavy Helmet A, Buckler B, Shield B, Skill: Sword, Gun, Makina, Artificial, Passive: Can Equip Swords and Guns, Quantization, Dual Wield, Buster Bit, Over Lock-On, High Advanced CIWS, Assist Full Burst, Assault System"
]],
    7444 => # シンギュラリティ
      [[ "The ultimate artificial intelligence that has reached the point of technological saturation It invades all inorganic matter mechanizing it as part of itself Its immense power is said to have led multiple worlds to ruin The SKL it learns are extremely powerful with both combat ability and defensive performance being exceptionally high",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Breastplate S, Shell S, Armor SSS, Heavy Armor SSS, Skimpy SS, Hat SS, Helmet SSS, Heavy Helmet SSS, Buckler SS, Shield SS, Skill: Sword, Gun, Makina, Artificial, Passive: Can Equip Swords and Guns, Complete Quantization, Dual Wield, Omega Bit, Over Lock-On, Omega CIWS, Assist Giga Burst, Assault System, End of Turn Sophisticate chance"
]],
    7408 => # 巨人 / Giant
      [[
        "A rare species with a massive body, believed to be a mutation of humans and elves. They are extremely sturdy and strong with very high vitality. They boast great destructive power and can learn abilities suited to the use of Charge skills. However, they are not very good at magic and lack speed.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Hat,Helmet,Fancy Cap",
        "Skills: Giant",
        "Passive: None",
      ]],
    7409 => # ギガース / Gigas
      [[
        "An evolved species of Giants that boasts a body that defies common sense. Their vitality and sturdiness are unsurpassed, and they boasts extraordinary strength. The destructive power of their Charge skills and offensive techniques that make use of their gigantic size is tremendous. However, mind their low speed and vulnerability to status ailments.",
        "",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Hat,Helmet,Fancy Cap",
        "Skills: Giant",
        "Passive: None",
      ]],
    7410 => # 巨神 / Titan
      [[
        "The ultimate giant, revered as a deity. The destruction wrought by their massive body is tantamount to disaster. Their abilities, which assist their Charge skills, give them explosive power. However, their speed is low and they are vulnerable to status ailments, so they require protective measures.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Hat,Helmet,Fancy Cap",
        "Skills: Giant",
        "Passive: None",
      ]],
    7445 => # 巨神王
      [[ "The legendary giant said to have rampaged during the Great Monster Wars Due to causing significant damage to the angel army it was sealed after the war Its overwhelming ATK from its massive body annihilates enemies in front of it Its acquired abilities are extremely powerful making it the strongest front-line fighter",
  "",
  "",
  "",
  "",
  "",
],
[
  "Equipment Armor: Clothes C, Breastplate A, Hat A, Helmet C, High-grade Hat B, Skill: Staff, Axe, Flail, Giant, Passive: Increased Critical Rate, 50% Increased Critical Damage, Significantly increased power of Staff, Axe, Flail, and Giant, double SP consumption"
]],
    7446 => # 星喰い
      [[ "A cosmic giant that devours entire planets Considered a harbinger of destruction it was classified as a forbidden species by the gods Their power is immense bringing overwhelming destruction Their resistances are not high but their abundant vitality makes up for it",
  "",
  "",
  "",
],
[
  "Equip: Clothes S, Breastplate SSS, Hat SSS, Helmet S, Fancy Cap SS, Skill: Staff, Axe, Flail, Giant, Passive: Increased Critical Rate, 100% Increased Critical Damage, Staff Techniques, Axe Techniques, Flail Techniques, Giant Techniques power increased by 100%, SP consumption tripled, Galaxy attribute 100% up"
]],
    351 => # 下位アポトーシス / Lowly Apoptosis
      [[
        "An unknown entity from the realm of Tartarus, wholly unidentified and seemingly not as an ordinary organism. The only information recorded about the Apoptosis is that they are beings who can passively use Makina and Dark magic, have high stats, and ultimately strong immunity to all status ailments.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Shell,Robe,Dress,Skimpy,Hat",
        "   Helmet,Fancy Cap,Buckler,Shield",
        "Skills: Gun,Time Magic,Dark,Makina,Artificial",
        "Passive: None",
        "",
      ]],
    352 => # 上位アポトーシス / High Apoptosis
      [[
        "A high-ranking Apoptosis who commands all the others, with nothing known of its identity or origin. With innate talent at using Makina and Dark skills, not to mention the ability to control time, all coupled with her amazing stats, the High Apoptosis has full combat capabilities.",
        "",
        "",
        "",
        "",
      ],
      [
        "Equip: Clothes,Breastplate,Shell,Robe,Dress,Skimpy,Hat",
        "   Helmet,Fancy Cap,Buckler,Shield",
        "Skills: Gun,Time Magic,Dark,Makina,Artificial",
        "Passive: None",
        "",
      ]],
    7447 => # X型アポトーシス
      [[ "The highest-class Apoptosis said to have a unique model number Their true identity is unknown but their combat abilities are extremely high Masters the power of chaos and unknown mechanical technology to eliminate foreign objects Additionally their resistances are extremely high possessing power that sets them apart from the monsters of this world",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes B, Breastplate A, Shell A, Robe A, Dress B, Skimpy B, Hat B, Fancy Cap A, Helmet A, Buckler B, Shield B, Skill: Gun, Time Magic, Holy, Dark, Makina, Artificial, Chaos, Passive: Holy Techniques, Dark Techniques power increased by 50%, immune to all status ailments"
]],
    7448 => # XX型アポトーシス
      [[ "A transcendent being also called the Administrator Their scope is not limited to Apoptosis but also governs the workings of physical laws Naturally possesses immense power and extremely high combat abilities Their stats and resistances are extremely high capable of excelling on any battlefield",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Breastplate SSS, Shell SSS, Robe SSS, Dress SS, Skimpy SS, Hat SS, Fancy Cap SSS, Helmet SSS, Buckler SS, Shield SS, Skill: Gun, Time Magic, Holy, Dark, Makina, Artificial, Chaos, Passive: Maximize Holy and Dark Technique Power, Immune to All Status Ailments"
]],
    7449 => # 混沌の使徒
      [[ "Administrators of physical laws incarnated according to the Gestation of Chaos No longer confined to the realm of Apoptosis possessing power equal to that of gods In battle they demonstrate power that transcends all things With overwhelming power they return everything to chaos",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Breastplate SSS, Shell SSS, Robe SSS, Dress SS, Skimpy SS, Hat SS, Fancy Cap SSS, Helmet SSS, Buckler SS, Shield SS, Skill: Gun, Time Magic, Holy, Dark, Makina, Artificial, Chaos, Passive: Holy and Dark Techniques Ultimate Power-Up 100% All Status Ailments Invalidated, Ignore Time Stop, Activates All or Nothing on Counter"
]],
    7450 => # 創世の女神
      [[ "The ultimate holy elemental lifeform considered the primordial light Reigning over heaven and earth as the Goddess who created this world Possessing the power of an absolute being unmatched except by the Dark Goddess Can learn holy SKL with ultimate power",
  "",
  "",
  "",
],
[
  "Equip: Clothes SS, Gi SS, Armor S, Heavy Armor S, Robe SSS, Dress SSS, Skimpy SSS, Hat SS, Helmet S, Heavy Helmet S, Magic Hat SSS, Fancy Cap SSS, Buckler SS, Shield SS, Heavy Shield S, Skill: White Magic, Time Magic, Holy, Passive: Holy Techniques Ultimate Power-Up 100% Holy Resistance Penetration MP Ultimate Consumption Down, Body of the Gods"
]],
    7451 => # 邪神
      [[ "The ultimate dark lifeform considered the primordial darkness Worshipped as the Dark Goddess by all monsters Their power is that of a god unmatched except by the Goddess Can learn dark SKL with ultimate power",
  "",
  "",
],
[
  "Equip: Clothes SS,Gi SS,Armor SSS,Heavy Armor SSS,Robe S,Dress S,Skimpy S,Hat SS,Helmet SSS,Heavy Helmet SSS,Magic Hat S,Fancy Cap SS,Buckler SSS,Shield SSS,Heavy Shield SSS.Skill: Sword, Rapier, Scythe, Black Magic, Time Magic, Dark, Demon Arts, Beast, Snake, Tentacle, Wing, Insect, Plant, Nature, Breath. Passive: Ultimate Dark Skill Power Up 100%, Dark Resistance Penetration, Ultimate SP Consumption Down, Passive: No HP Consumption for Dark Attribute"
]],
    7452 => # 第三の神
      [[ "The third god awakened to the power of chaos possessing power on par with the Goddess and the Dark Goddess. Possesses both holy and dark powers and can also use chaotic powers. Has the power to interfere with time and space and can restore life force from space. Excels in both offense and defense wielding power truly worthy of being called a god.",
  "",
  "",
  "",
],
[
  "Equip:\\I[1890],\\I[2200],\\I[1923],\\I[2213] S, \\I[1769],\\I[1781],\\I[2156],\\I[2256],\\I[2254],\\I[2275] SS, \\I[2031],\\I[4261],\\I[4267],\\I[2175],\\I[2365] SSS. Skill:\\I[207],\\I[206],\\I[208],\\I[171],\\I[177],\\I[205],\\I[3842],\\I[3973],\\I[3974],\\I[3761],\\I[3975],\\I[3355],\\I[157],\\I[144],Chaos. Passive: Holy & Dark skill ultimate power up 100%, Holy & Dark resistance penetration, SP and MP consumption halved, Ruler of Darkness, Universal Resistance +25%, Ignore Time Stop"
]],
    7453 => # カオス
      [[ "A chaos with a will existing as time and space itself Existing in the rift of chaos as the administrator of time and space Learns the ultimate secrets of Dark SKL and Time Magic freely manipulating time Boasts absolute and ultimate power befitting a transcendent being",
  "",
  "",
  "",
],
[
  "Equip: All Armor SSS, Skill: All, Passive: Holy and Dark skill ultimate power up 100%, Holy and Dark resistance penetration, Life Restoration, Magic Restoration, Stamina Restoration, Ruler of Darkness, Universal Resistance +50%, Ignore Time Stop, Time Stop Counter"
]],
    7454 => # 混沌の精霊
      [[ "A spirit born from the miasma of chaos mediated by an unknown invasive organism Possesses the ability to consume chaos storing or releasing it within its body The countless tentacles extending from its body are said to be chaos itself Boasts overwhelming combat capability due to its ability to erode and neutralize chaos",
  "",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Breastplate SSS, Shell SSS, Robe SSS, Dress SS, Skimpy SS, Hat SSS, Fancy Cap SSS, Helmet SSS, Light Shield SS, Shield SS, Skill: Gun, Time Magic, Holy, Dark, Makina, Tentacle, Artificial, Nature, Chaos, Passive: Holy and Dark skill ultimate power up 100%, Nullify all status ailments, Ignore Time Stop, Activates Bullet Time on Counter"
]],
    7455 => # デウスエクスマキナ
      [[ "The ultimate puppet said to manage time and space Said to be in an eternal slumber within chaos The ability to control time and space demonstrates overwhelming power in battle Freely manipulates dark power reigning as the absolute ruler of space",
  "",
  "",
  "",
],
[
  "Equip: Clothes SSS, Breastplate SSS, Armor SSS, Heavy Armor SSS, Shell S, Robe SS, Dress SSS, Skimpy SSS, Hat SSS, Helmet SSS, Heavy Helmet SSS, Fancy Cap SSS, Light Shield SS, Shield SS, Heavy Shield SS, Skill: Gun, Time Magic, Holy, Dark, Dance, Sing, Makina, Service, Demon Arts, Artificial, Chaos, Passive: Holy and Dark skill ultimate power up 100%, Ultimate tenacity, Halve Chaos Attribute Damage, Ignore Time Stop, Activates Witch Time on Counter"
]],
  }
  
end

